/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.ProjectIndexInfoResolver;
import com.atlassian.jira.jql.resolver.ProjectResolver;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.ProjectValuesExistValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.jql.validator.ValuesExistValidator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;
import java.util.Collection;

public class ProjectValidator
implements ClauseValidator {
    private final ValuesExistValidator projectValuesExistValidator;
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final I18nHelper.BeanFactory beanFactory;

    public ProjectValidator(ProjectResolver projectResolver, JqlOperandResolver operandResolver, PermissionManager permissionManager, ProjectManager projectManager, I18nHelper.BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.projectValuesExistValidator = this.getValuesValidator(projectResolver, operandResolver, permissionManager, projectManager);
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
    }

    public MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause) {
        MessageSet messageSet = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!messageSet.hasAnyErrors()) {
            messageSet.addMessageSet(this.projectValuesExistValidator.validate(searcher, terminalClause));
        }
        return messageSet;
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(new Collection[]{OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY});
    }

    ValuesExistValidator getValuesValidator(ProjectResolver projectResolver, JqlOperandResolver operandResolver, PermissionManager permissionManager, ProjectManager projectManager) {
        return new ProjectValuesExistValidator(operandResolver, new ProjectIndexInfoResolver(projectResolver), permissionManager, projectManager, this.beanFactory);
    }
}

