/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class LabelsClauseValuesGenerator
implements ClauseValuesGenerator {
    private final LabelManager labelManager;

    public LabelsClauseValuesGenerator(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser user, String jqlClauseName, String valuePrefix, int maxNumResults) {
        ApplicationUser searcher = user;
        TreeSet suggestions = new TreeSet();
        Collection fieldIds = this.getSearchHandlerManager().getFieldIds(searcher, jqlClauseName);
        for (String fieldId : fieldIds) {
            if (fieldId.equals(SystemSearchConstants.forLabels().getFieldId())) {
                suggestions.addAll(this.labelManager.getSuggestedLabels(searcher, null, valuePrefix));
                continue;
            }
            suggestions.addAll(this.labelManager.getSuggestedLabels(searcher, null, CustomFieldUtils.getCustomFieldId((String)fieldId), valuePrefix));
        }
        ArrayList results = Lists.newArrayListWithCapacity((int)suggestions.size());
        for (String suggestion : suggestions) {
            if (results.size() == maxNumResults) break;
            results.add(new ClauseValuesGenerator.Result(suggestion));
        }
        return new ClauseValuesGenerator.Results((List)results);
    }

    SearchHandlerManager getSearchHandlerManager() {
        return (SearchHandlerManager)ComponentAccessor.getComponentOfType(SearchHandlerManager.class);
    }
}

