/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.fugue.Option;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseMaintenancePredicate;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public final class LicenseMaintenancePredicateImpl
implements LicenseMaintenancePredicate {
    private final ApplicationManager applicationManager;
    private final BuildUtilsInfo info;

    @Inject
    public LicenseMaintenancePredicateImpl(ApplicationManager applicationManager, BuildUtilsInfo info) {
        this.applicationManager = (ApplicationManager)Assertions.notNull((String)"applicationManager", (Object)applicationManager);
        this.info = (BuildUtilsInfo)Assertions.notNull((String)"info", (Object)info);
    }

    @Override
    public boolean test(@Nonnull LicenseDetails details) {
        Assertions.notNull((String)"details", (Object)details);
        Set licensedApplicationKeys = details.getLicensedApplications().getKeys();
        for (ApplicationKey key : licensedApplicationKeys) {
            Date buildDate;
            Option appOption = this.applicationManager.getApplication(key);
            if (!appOption.isDefined() || details.isMaintenanceValidForBuildDate(buildDate = ((Application)appOption.get()).buildDate().toDate())) continue;
            return false;
        }
        return details.isMaintenanceValidForBuildDate(this.info.getCurrentBuildDate());
    }
}

