/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding;

import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.PropertiesManager;
import com.atlassian.jira.onboarding.UserChecker;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.web.HttpServletVariables;
import com.atlassian.jira.web.util.CookieUtils;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCheckerImpl
implements UserChecker {
    private static final Logger log = LoggerFactory.getLogger(UserCheckerImpl.class);
    private static final String IMPERSONATION_COOKIE = "um.user.impersonated.username";
    private final UserKeyStore userKeyStore;
    private final LoginService loginService;
    private final FeatureManager featureManager;
    private final GlobalPermissionManager permissionManager;
    private final PropertiesManager propertiesManager;
    private final HttpServletVariables httpServetVariables;

    public UserCheckerImpl(UserKeyStore userKeyStore, LoginService loginService, FeatureManager featureManager, GlobalPermissionManager permissionManager, PropertiesManager propertiesManager, HttpServletVariables httpServetVariables) {
        this.userKeyStore = userKeyStore;
        this.loginService = loginService;
        this.featureManager = featureManager;
        this.permissionManager = permissionManager;
        this.propertiesManager = propertiesManager;
        this.httpServetVariables = httpServetVariables;
    }

    @Override
    public boolean firstTimeLoggingIn(@Nonnull ApplicationUser user) {
        log.debug("current user id is {}, user id threshold is {}", (Object)this.userKeyStore.getIdForUserKey(user.getKey()), (Object)this.getUserIdThreshold());
        Long loginCount = this.loginService.getLoginInfo(user.getUsername()).getLoginCount();
        if (this.userKeyStore.getIdForUserKey(user.getKey()) <= this.getUserIdThreshold()) {
            return loginCount != null && loginCount == 1L;
        }
        return loginCount == null || loginCount == 1L;
    }

    @Override
    public boolean isOnDemandSysAdmin(@Nonnull ApplicationUser user) {
        return this.featureManager.isOnDemand() && this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
    }

    @Override
    public boolean isImpersonationActive(@Nonnull ApplicationUser user) {
        String impersonationCookieValue = CookieUtils.getCookieValue((String)IMPERSONATION_COOKIE, (HttpServletRequest)this.httpServetVariables.getHttpRequest());
        if (impersonationCookieValue != null) {
            try {
                impersonationCookieValue = URLDecoder.decode(impersonationCookieValue, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return StringUtils.isNotBlank((CharSequence)user.getUsername()) && user.getUsername().equals(impersonationCookieValue);
    }

    private Long getUserIdThreshold() {
        PropertySet propertySet = this.propertiesManager.getPropertySet();
        if (propertySet.exists("jira.onboarding.app_user.id.threshold")) {
            try {
                return Long.valueOf(propertySet.getString("jira.onboarding.app_user.id.threshold"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Long.MAX_VALUE;
    }
}

