/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.Collections;
import java.util.List;

public class CurrentLoginFunction
extends AbstractJqlFunction {
    public static final String FUNCTION_CURRENT_LOGIN = "currentLogin";
    private final LoginService loginService;

    public CurrentLoginFunction(LoginService loginService) {
        this.loginService = loginService;
    }

    public MessageSet validate(ApplicationUser searcher, FunctionOperand operand, TerminalClause terminalClause) {
        return this.validateNumberOfArgs(operand, 0);
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 0;
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.DATE;
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        LoginInfo loginInfo;
        Long lastLoginTime;
        if (queryCreationContext == null || queryCreationContext.getQueryUser() == null) {
            return Collections.emptyList();
        }
        ApplicationUser user = queryCreationContext.getQueryUser();
        if (user != null && (lastLoginTime = (loginInfo = this.loginService.getLoginInfo(user.getName())).getLastLoginTime()) != null) {
            return Collections.singletonList(new QueryLiteral((Operand)operand, lastLoginTime));
        }
        return Collections.emptyList();
    }
}

