/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.navigation;

import com.atlassian.extras.api.LicenseType;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.navigation.FooterModuleDescriptor;
import com.atlassian.jira.plugin.navigation.PluggableFooter;
import com.atlassian.jira.plugin.util.ModuleDescriptorXMLUtils;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class FooterModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<PluggableFooter>
implements FooterModuleDescriptor {
    private static final String VIEW_TEMPLATE = "view";
    public static final String LICENSE_MESSAGE_INFO = "licensemessage";
    public static final String LICENSE_MESSAGE_ERROR = "licensemessagered";
    private final JiraLicenseService jiraLicenseService;
    private final BuildUtilsInfo buildUtilsInfo;
    private final GlobalPermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;
    private final ClusterManager clusterManager;
    private final JiraLicenseManager licenseManager;
    private final ApplicationRoleManager applicationRoleManager;
    private int order;

    public FooterModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, JiraLicenseService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, ModuleFactory moduleFactory, GlobalPermissionManager permissionManager, ApplicationProperties applicationProperties, ClusterManager clusterManager, JiraLicenseManager licenseManager, ApplicationRoleManager applicationRoleManager) {
        super(authenticationContext, moduleFactory);
        this.licenseManager = licenseManager;
        this.applicationRoleManager = applicationRoleManager;
        this.clusterManager = (ClusterManager)Assertions.notNull((String)"clusterManager", (Object)clusterManager);
        this.jiraLicenseService = (JiraLicenseService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.order = ModuleDescriptorXMLUtils.getOrder((Element)element);
    }

    @Override
    public void enabled() {
        super.enabled();
    }

    public int getOrder() {
        return this.order;
    }

    public String getFooterHtml(HttpServletRequest request, Map<String, ?> startingParams) {
        Map<String, ?> params = this.createVelocityParams(request, startingParams);
        return this.getHtml(VIEW_TEMPLATE, params);
    }

    protected Map<String, ?> createVelocityParams(HttpServletRequest request, Map<String, ?> startingParams) {
        HashMap params = startingParams != null ? new HashMap(startingParams) : new HashMap();
        String licenseMessageClass = null;
        if (!this.jiraLicenseService.isLicenseSet()) {
            params.put("notfull", Boolean.TRUE);
            params.put("unlicensed", Boolean.TRUE);
            licenseMessageClass = LICENSE_MESSAGE_ERROR;
            params.put("organisation", "<Unknown>");
        } else if (this.licenseManager.hasLicenseTooOldForBuildConfirmationBeenDone()) {
            params.put("confirmedWithOldLicense", Boolean.TRUE);
            licenseMessageClass = LICENSE_MESSAGE_ERROR;
        } else {
            Iterable licenses = this.jiraLicenseService.getLicenses();
            LinkedHashSet organisations = Sets.newLinkedHashSetWithExpectedSize((int)Iterables.size((Iterable)licenses));
            for (LicenseDetails licenseDetails : licenses) {
                if (!StringUtils.isBlank((String)licenseDetails.getOrganisation())) {
                    organisations.add(licenseDetails.getOrganisation());
                }
                if (!licenseDetails.isEvaluation() && (licenseDetails.isCommercial() || licenseDetails.isStarter())) continue;
                params.put("notfull", Boolean.TRUE);
                if (licenseDetails.isEvaluation()) {
                    params.put("evaluation", Boolean.TRUE);
                    licenseMessageClass = LICENSE_MESSAGE_ERROR;
                    continue;
                }
                if (licenseMessageClass != null) continue;
                LicenseType licenseType = licenseDetails.getLicenseType();
                if (licenseType == LicenseType.COMMUNITY) {
                    params.put("community", Boolean.TRUE);
                    licenseMessageClass = LICENSE_MESSAGE_INFO;
                    continue;
                }
                if (licenseType == LicenseType.OPEN_SOURCE) {
                    params.put("opensource", Boolean.TRUE);
                    licenseMessageClass = LICENSE_MESSAGE_INFO;
                    continue;
                }
                if (licenseType == LicenseType.NON_PROFIT) {
                    params.put("nonprofit", Boolean.TRUE);
                    licenseMessageClass = LICENSE_MESSAGE_INFO;
                    continue;
                }
                if (licenseType == LicenseType.DEMONSTRATION) {
                    params.put("demonstration", Boolean.TRUE);
                    licenseMessageClass = LICENSE_MESSAGE_INFO;
                    continue;
                }
                if (licenseType == LicenseType.DEVELOPER) {
                    params.put("developer", Boolean.TRUE);
                    licenseMessageClass = LICENSE_MESSAGE_INFO;
                    continue;
                }
                if (licenseType != LicenseType.PERSONAL) continue;
                params.put("personal", licenseDetails.isPersonalLicense());
                licenseMessageClass = LICENSE_MESSAGE_INFO;
            }
            params.put("organisation", StringUtils.join((Collection)organisations, (String)", "));
        }
        if (licenseMessageClass != null) {
            params.put("licenseMessageClass", licenseMessageClass);
        }
        params.put("serverid", this.jiraLicenseService.getServerId());
        params.put("externalLinkUtil", ExternalLinkUtilImpl.getInstance());
        params.put("utilTimerStack", new UtilTimerStack());
        params.put("version", this.buildUtilsInfo.getVersion());
        params.put("buildNumber", this.buildUtilsInfo.getCurrentBuildNumber());
        params.put("req", request);
        params.put("build", this.buildUtilsInfo);
        params.put("string", new StringUtils());
        params.put("isSysAdmin", this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, this.getAuthenticationContext().getUser()));
        params.put("showContactAdminForm", this.applicationProperties.getOption("jira.show.contact.administrators.form"));
        if (this.clusterManager.isClustered()) {
            params.put("nodeId", this.clusterManager.getNodeId());
        }
        return params;
    }
}

