/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.contextproviders;

import com.atlassian.jira.application.JiraApplicationManager;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.plugin.webfragment.contextproviders.AbstractJiraContextProvider;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.util.HelpUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class HelpContextProvider
extends AbstractJiraContextProvider {
    private final JiraAuthenticationContext authenticationContext;
    private final HelpUrls helpUrls;
    private final JiraApplicationManager applicationManager;

    public HelpContextProvider(JiraAuthenticationContext authenticationContext, HelpUrls helpUrls, JiraApplicationManager applicationManager) {
        this.authenticationContext = authenticationContext;
        this.helpUrls = helpUrls;
        this.applicationManager = applicationManager;
    }

    public Map getContextMap(ApplicationUser user, JiraHelper jiraHelper) {
        HashMap context = Maps.newHashMap();
        context.put("i18n", this.authenticationContext.getI18nHelper());
        context.put("helpUrls", this.helpUrls);
        HelpUrl coreHelp = this.helpUrls.getUrlForApplication(this.applicationManager.getPlatform().getKey(), "default");
        context.put("coreHelpUrl", coreHelp.getUrl());
        context.put("helpUtil", HelpUtil.getInstance());
        return context;
    }
}

