/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template.hook;

import com.atlassian.jira.project.template.descriptor.ConfigTemplateParser;
import com.atlassian.jira.project.template.descriptor.ProjectTemplateModuleDescriptor;
import com.atlassian.jira.project.template.hook.AddProjectHook;
import com.atlassian.jira.project.template.hook.AddProjectModule;
import com.atlassian.jira.project.template.hook.ConfigTemplate;
import com.atlassian.jira.project.template.hook.IssueTypeSchemeTemplate;
import com.atlassian.jira.project.template.hook.IssueTypeTemplate;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.base.Strings;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class AddProjectModuleImpl
implements AddProjectModule {
    private final String addProjectHookClass;
    private final ModuleFactory moduleFactory;
    private final ProjectTemplateModuleDescriptor moduleDescriptor;
    private final ConfigTemplate configTemplate;

    public AddProjectModuleImpl(ModuleFactory moduleFactory, ProjectTemplateModuleDescriptor moduleDescriptor, String addProjectHookClass, String templateConfigurationFile, ConfigTemplateParser configTemplateParser) {
        this.moduleFactory = moduleFactory;
        this.moduleDescriptor = moduleDescriptor;
        this.addProjectHookClass = addProjectHookClass;
        if (templateConfigurationFile == null) {
            this.configTemplate = null;
        } else {
            this.configTemplate = configTemplateParser.parse(templateConfigurationFile, moduleDescriptor.getPlugin());
            this.addIconResources();
        }
    }

    private void addIconResources() {
        if (this.configTemplate.issueTypeSchemeTemplate().isPresent()) {
            for (IssueTypeTemplate issueTypeTemplate : ((IssueTypeSchemeTemplate)this.configTemplate.issueTypeSchemeTemplate().get()).issueTypeTemplates()) {
                String iconPath = issueTypeTemplate.iconPath();
                String iconName = new File(iconPath).getName();
                this.moduleDescriptor.addResource(iconPath, iconName);
            }
        }
    }

    public boolean hasConfigTemplate() {
        return this.configTemplate() != null;
    }

    public ConfigTemplate configTemplate() {
        return this.configTemplate;
    }

    public boolean hasProjectCreateHook() {
        return !StringUtils.isBlank((CharSequence)this.addProjectHookClass);
    }

    public AddProjectHook addProjectHook() {
        if (Strings.isNullOrEmpty((String)this.addProjectHookClass)) {
            return null;
        }
        Object module = this.moduleFactory.createModule(this.addProjectHookClass, (ModuleDescriptor)this.moduleDescriptor);
        try {
            return (AddProjectHook)module;
        }
        catch (ClassCastException ex) {
            throw new PluginException("The class '" + this.addProjectHookClass + "' is not an instance of AddProjectHook.", (Throwable)ex);
        }
    }
}

