/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.version;

import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.model.querydsl.QVersion;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionStore;
import com.atlassian.jira.util.NamedPredicates;
import com.google.common.collect.Iterables;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.types.Predicate;
import java.util.Collection;
import javax.annotation.Nonnull;

public class OfBizVersionStore
implements VersionStore {
    static final String ENTITY_NAME = "Version";
    private final EntityEngine entityEngine;
    private final DbConnectionManager dbConnectionManager;

    public OfBizVersionStore(EntityEngine entityEngine, DbConnectionManager dbConnectionManager) {
        this.entityEngine = entityEngine;
        this.dbConnectionManager = dbConnectionManager;
    }

    @Override
    @Nonnull
    public Iterable<Version> getAllVersions() {
        return this.entityEngine.selectFrom(Entity.VERSION).findAll().list();
    }

    @Override
    @Nonnull
    public Iterable<Version> getVersionsByName(@Nonnull String name) {
        return Iterables.filter(this.getAllVersions(), NamedPredicates.equalsIgnoreCase(name));
    }

    @Override
    @Nonnull
    public Iterable<Version> getVersionsByProject(@Nonnull Long projectId) {
        return this.entityEngine.selectFrom(Entity.VERSION).whereEqual("project", projectId).orderBy("sequence");
    }

    @Override
    @Nonnull
    public Version createVersion(@Nonnull Version version) {
        return this.entityEngine.createValue(Entity.VERSION, version);
    }

    @Override
    public void storeVersion(@Nonnull Version version) {
        this.entityEngine.updateValue(Entity.VERSION, version);
    }

    @Override
    public void storeVersions(@Nonnull Collection<Version> versions) {
        for (Version version : versions) {
            if (version == null) continue;
            this.storeVersion(version);
        }
    }

    @Override
    public Version getVersion(@Nonnull Long id) {
        return this.entityEngine.selectFrom(Entity.VERSION).findById(id);
    }

    @Override
    public void deleteVersion(@Nonnull Version version) {
        this.entityEngine.removeValue(Entity.VERSION, version.getId());
    }

    @Override
    public void deleteAllVersions(@Nonnull Long projectId) {
        this.dbConnectionManager.execute(dbConnection -> dbConnection.delete((RelationalPath<?>)QVersion.VERSION).where((Predicate)QVersion.VERSION.project.eq((Object)projectId)).execute());
    }
}

