/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorComparator;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class DefaultRoleActorsImpl
implements DefaultRoleActors {
    private final Long projectRoleId;
    private final Set<RoleActor> roleActors;

    public DefaultRoleActorsImpl(Long projectRoleId, Set<? extends RoleActor> roleActors) {
        this.projectRoleId = projectRoleId;
        this.roleActors = ImmutableSet.copyOf(roleActors);
    }

    public DefaultRoleActorsImpl(Long projectRoleId, RoleActor roleActor) {
        this(projectRoleId, (Set<? extends RoleActor>)ImmutableSet.of((Object)roleActor));
    }

    public Set<ApplicationUser> getUsers() {
        HashSet<ApplicationUser> allUsers = new HashSet<ApplicationUser>();
        if (this.roleActors != null) {
            Iterator<RoleActor> iterator = this.roleActors.iterator();
            while (iterator.hasNext()) {
                RoleActor roleActor;
                RoleActor actor = roleActor = iterator.next();
                for (ApplicationUser user : actor.getUsers()) {
                    allUsers.add(user);
                }
            }
        }
        return allUsers;
    }

    public Set<ApplicationUser> getApplicationUsers() {
        HashSet<ApplicationUser> allUsers = new HashSet<ApplicationUser>();
        if (this.roleActors != null) {
            Iterator<RoleActor> iterator = this.roleActors.iterator();
            while (iterator.hasNext()) {
                RoleActor roleActor;
                RoleActor actor = roleActor = iterator.next();
                for (ApplicationUser user : actor.getUsers()) {
                    allUsers.add(user);
                }
            }
        }
        return allUsers;
    }

    public Set<RoleActor> getRoleActors() {
        return this.roleActors;
    }

    public Long getProjectRoleId() {
        return this.projectRoleId;
    }

    public Set<RoleActor> getRoleActorsByType(String type) {
        TreeSet<RoleActor> roleActorsForType = new TreeSet<RoleActor>(RoleActorComparator.COMPARATOR);
        for (RoleActor roleActor1 : this.roleActors) {
            RoleActor roleActor = roleActor1;
            if (!roleActor.getType().equals(type)) continue;
            roleActorsForType.add(roleActor);
        }
        return roleActorsForType;
    }

    public boolean contains(ApplicationUser user) {
        for (RoleActor roleActor1 : this.roleActors) {
            RoleActor roleActor = roleActor1;
            if (!roleActor.contains(user)) continue;
            return true;
        }
        return false;
    }

    public DefaultRoleActors addRoleActor(RoleActor roleActor) {
        HashSet set = Sets.newHashSet(this.roleActors);
        set.add(roleActor);
        return new DefaultRoleActorsImpl(this.projectRoleId, set);
    }

    public DefaultRoleActors addRoleActors(Collection<? extends RoleActor> roleActors) {
        HashSet set = Sets.newHashSet(this.roleActors);
        set.addAll(roleActors);
        return new DefaultRoleActorsImpl(this.projectRoleId, set);
    }

    public DefaultRoleActors removeRoleActor(RoleActor roleActor) {
        if (!this.roleActors.contains(roleActor)) {
            return this;
        }
        HashSet set = Sets.newHashSet(this.roleActors);
        set.remove(roleActor);
        return new DefaultRoleActorsImpl(this.projectRoleId, set);
    }

    public DefaultRoleActors removeRoleActors(Collection<? extends RoleActor> roleActors) {
        HashSet set = Sets.newHashSet(this.roleActors);
        set.removeAll(roleActors);
        return new DefaultRoleActorsImpl(this.projectRoleId, set);
    }

    public String toString() {
        return "DefaultRoleActorsImpl[projectRoleId=" + this.projectRoleId + ",roleActors=" + this.roleActors + ']';
    }
}

