/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.util.log.Log4jKit;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRunner
implements JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceRunner.class);
    private static final String MOCK_USER_NAME = "ServiceRunner";

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        Map parameters = jobRunnerRequest.getJobConfig().getParameters();
        Long serviceId = (Long)parameters.get(ServiceManager.SERVICE_ID_KEY);
        if (serviceId == null) {
            return JobRunnerResponse.failed((String)("Service entry with job ID '" + jobRunnerRequest.getJobId() + "' has no job config parameters"));
        }
        return ServiceRunner.runServiceId(serviceId);
    }

    private static JobRunnerResponse runServiceId(Long serviceId) {
        JobRunnerResponse response;
        try {
            ServiceManager serviceManager = (ServiceManager)ComponentAccessor.getComponent(ServiceManager.class);
            JiraServiceContainer service = serviceManager.getServiceWithId(serviceId);
            response = service == null ? JobRunnerResponse.aborted((String)("Service ID '" + serviceId + "' no longer exists!")) : ServiceRunner.runService(service);
        }
        catch (Exception e) {
            LOG.error("An error occurred while trying to run service with ID '" + serviceId + "'. " + e.getMessage(), (Throwable)e);
            response = JobRunnerResponse.failed((Throwable)e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JobRunnerResponse runService(JiraServiceContainer service) {
        String serviceName = service.getName();
        ServiceRunner.setLog4JInfo(MOCK_USER_NAME, serviceName);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running Service [" + service + ']');
            }
            ComponentAccessor.getJiraAuthenticationContext().clearLoggedInUser();
            service.run();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished Running Service [" + service + ']');
            }
            JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success();
            return jobRunnerResponse;
        }
        catch (RuntimeException e) {
            LOG.error("An error occurred while trying to run service '" + serviceName + "'. " + e.getMessage(), (Throwable)e);
            JobRunnerResponse jobRunnerResponse = JobRunnerResponse.failed((Throwable)e);
            return jobRunnerResponse;
        }
        finally {
            service.setLastRun();
            ServiceRunner.setLog4JInfo(MOCK_USER_NAME, "");
        }
    }

    private static void setLog4JInfo(String userName, String serviceName) {
        Log4jKit.clearMDC();
        Log4jKit.putToMDC(userName, "", "", serviceName, "");
    }
}

