/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.ShareTypeValidatorUtils;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.util.dbc.Assertions;

public class DefaultShareTypeValidatorUtils
implements ShareTypeValidatorUtils {
    private final ShareTypeFactory shareTypeFactory;
    private final PermissionManager permissionManager;

    public DefaultShareTypeValidatorUtils(ShareTypeFactory shareTypeFactory, PermissionManager permissionManager) {
        Assertions.notNull((String)"shareTypeFactory", (Object)shareTypeFactory);
        Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.permissionManager = permissionManager;
        this.shareTypeFactory = shareTypeFactory;
    }

    @Deprecated
    public boolean isValidSharePermission(JiraServiceContext context, SharedEntity entity) {
        return this.hasValidSharePermissions(context, entity);
    }

    public boolean hasValidSharePermissions(JiraServiceContext context, SharedEntity entity) {
        Assertions.notNull((String)"entity", (Object)entity);
        SharedEntity.SharePermissions permissions = entity.getPermissions();
        Assertions.notNull((String)"permissions", (Object)permissions);
        if (!permissions.isPrivate()) {
            boolean hasPermission = this.permissionManager.hasPermission(22, context.getLoggedInUser());
            if (!hasPermission) {
                String userName = context.getLoggedInUser() != null ? context.getLoggedInUser().getDisplayName() : context.getI18nBean().getText("common.words.Anonymous");
                this.addErrorToContext(context, "shares", "common.sharing.exception.no.share.permission", new Object[0]);
                this.addErrorToContext(context, "shares_delegated", "common.sharing.exception.delegated.user.no.share.permission", userName);
                return false;
            }
            for (SharePermission sharePermission : permissions) {
                this.isValidSharePermission(context, sharePermission, permissions.size());
            }
        }
        return !context.getErrorCollection().hasAnyErrors();
    }

    private boolean isValidSharePermission(JiraServiceContext context, SharePermission sharePermission, long entityPermissionCount) {
        ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
        if (type == null) {
            this.addErrorToContext(context, "shares", "common.sharing.exception.unknown.type", sharePermission.getType());
        } else {
            if (type.isSingleton() && entityPermissionCount > 1L) {
                this.addErrorToContext(context, "shares", "common.sharing.exception.singleton", sharePermission.getType());
            }
            type.getValidator().checkSharePermission(context, sharePermission);
        }
        return !context.getErrorCollection().hasAnyErrors();
    }

    public boolean isValidSearchParameter(JiraServiceContext context, ShareTypeSearchParameter searchParameter) {
        Assertions.notNull((String)"context", (Object)context);
        Assertions.notNull((String)"searchParameter", (Object)searchParameter);
        ShareType.Name shareType = searchParameter.getType();
        ShareType type = this.shareTypeFactory.getShareType(shareType);
        if (type == null) {
            this.addErrorToContext(context, "shares", "common.sharing.exception.unknown.type", shareType);
            return false;
        }
        return type.getValidator().checkSearchParameter(context, searchParameter);
    }

    private void addErrorToContext(JiraServiceContext context, String field, String message, Object ... params) {
        String text = context.getI18nBean().getText(message, (Object)params);
        context.getErrorCollection().addError(field, text);
    }
}

