/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.service.services.analytics.JiraStartStopAnalyticHelper;
import com.atlassian.jira.service.services.analytics.start.JiraStartAnalyticEvent;
import com.atlassian.jira.service.services.analytics.stop.JiraStopAnalyticEvent;
import com.atlassian.jira.startup.JiraLauncher;

public class AnalyticsLauncher
implements JiraLauncher {
    final JiraStartStopAnalyticHelper jiraAnalyticHelper = new JiraStartStopAnalyticHelper();

    @Override
    public void start() {
        if (this.isJiraSetup()) {
            this.getEventPublisher().publish((Object)new JiraStartAnalyticEvent(this.jiraAnalyticHelper.getOnStartUsageStats(false)));
        }
    }

    @Override
    public void stop() {
        if (this.isJiraSetup()) {
            this.getEventPublisher().publish((Object)new JiraStopAnalyticEvent(this.jiraAnalyticHelper.getOnStopUsageStats()));
        }
    }

    public EventPublisher getEventPublisher() {
        return (EventPublisher)ComponentAccessor.getComponentOfType(EventPublisher.class);
    }

    private boolean isJiraSetup() {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        return "true".equals(applicationProperties.getString("jira.setup"));
    }
}

