/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.instrumentation.operations.OpTimerFactory;
import com.atlassian.jdk.utilities.runtimeinformation.RuntimeInformationFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.index.ha.DisasterRecoveryLauncher;
import com.atlassian.jira.instrumentation.DefaultInstrumentationListenerManager;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.issue.index.DefaultIndexManager;
import com.atlassian.jira.startup.ActiveServicesLauncher;
import com.atlassian.jira.startup.BootstrapContainerLauncher;
import com.atlassian.jira.startup.CacheWarmerLauncher;
import com.atlassian.jira.startup.ChecklistLauncher;
import com.atlassian.jira.startup.ClusteringChecklistLauncher;
import com.atlassian.jira.startup.ClusteringLauncher;
import com.atlassian.jira.startup.ComponentContainerLauncher;
import com.atlassian.jira.startup.DatabaseChecklistLauncher;
import com.atlassian.jira.startup.DatabaseLauncher;
import com.atlassian.jira.startup.EmbeddedDatabaseServerLauncher;
import com.atlassian.jira.startup.FailedPluginsLauncher;
import com.atlassian.jira.startup.ImageIOProviderScannerLauncher;
import com.atlassian.jira.startup.IndexRecoveryLauncher;
import com.atlassian.jira.startup.InstantUpgradeManager;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.startup.NotificationInstanceKiller;
import com.atlassian.jira.startup.ReindexRequestCleaner;
import com.atlassian.jira.startup.SystemInfoLauncher;
import com.atlassian.jira.startup.ThreadDumper;
import com.atlassian.jira.tenancy.JiraTenancyCondition;
import com.atlassian.jira.tenancy.TenantManager;
import com.atlassian.jira.upgrade.ConsistencyCheckImpl;
import com.atlassian.jira.upgrade.PluginSystemLauncher;
import com.atlassian.jira.util.StopWatch;
import com.atlassian.jira.util.devspeed.JiraDevSpeedTimer;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.threadlocal.BruteForceThreadLocalCleanup;
import com.atlassian.threadlocal.RegisteredThreadLocals;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJiraLauncher
implements JiraLauncher {
    private static final Logger log = LoggerFactory.getLogger(DefaultJiraLauncher.class);
    private final ChecklistLauncher startupChecklist;
    private final BootstrapContainerLauncher bootstrapContainerLauncher;
    private final ComponentContainerLauncher componentContainerLauncher;
    private final NotificationInstanceKiller notificationInstanceKiller;
    private final DatabaseLauncher databaseLauncher;
    private final PluginSystemLauncher pluginSystemLauncher;
    private final ConsistencyCheckImpl consistencyChecker;
    private final SystemInfoLauncher systemInfoLauncher;
    private final FailedPluginsLauncher preDbFailedPluginsLauncher;
    private final FailedPluginsLauncher postDbFailedPluginsLauncher;
    private final ClusteringLauncher clusteringLauncher;
    private final ClusteringChecklistLauncher clusteringChecklistLauncher;
    private final ActiveServicesLauncher activeServicesLauncher;
    private final JiraProperties jiraSystemProperties;
    private final DisasterRecoveryLauncher disasterRecoveryLauncher;
    private final ReindexRequestCleaner reindexRequestCleaner;
    private final EmbeddedDatabaseServerLauncher embeddedDatabaseServerLauncher;
    private final IndexRecoveryLauncher indexRecoveryLauncher;
    private final JohnsonProvider johnsonProvider;
    private final ImageIOProviderScannerLauncher imageIOProviderScannerLauncher;
    private final CacheWarmerLauncher cacheWarmerLauncher;
    private StopWatch preActivationTimer;

    public DefaultJiraLauncher(JohnsonProvider johnsonProvider) {
        this.johnsonProvider = johnsonProvider;
        this.jiraSystemProperties = JiraSystemProperties.getInstance();
        this.startupChecklist = new ChecklistLauncher(this.jiraSystemProperties, johnsonProvider);
        this.bootstrapContainerLauncher = new BootstrapContainerLauncher();
        this.componentContainerLauncher = new ComponentContainerLauncher();
        this.notificationInstanceKiller = new NotificationInstanceKiller();
        this.databaseLauncher = new DatabaseLauncher(this.jiraSystemProperties);
        this.pluginSystemLauncher = new PluginSystemLauncher(this.jiraSystemProperties);
        this.consistencyChecker = new ConsistencyCheckImpl(johnsonProvider);
        this.systemInfoLauncher = new SystemInfoLauncher();
        this.preDbFailedPluginsLauncher = new FailedPluginsLauncher();
        this.postDbFailedPluginsLauncher = new FailedPluginsLauncher();
        this.clusteringLauncher = new ClusteringLauncher();
        this.clusteringChecklistLauncher = new ClusteringChecklistLauncher(johnsonProvider);
        this.activeServicesLauncher = new ActiveServicesLauncher(johnsonProvider);
        this.disasterRecoveryLauncher = new DisasterRecoveryLauncher();
        this.embeddedDatabaseServerLauncher = new EmbeddedDatabaseServerLauncher();
        this.reindexRequestCleaner = new ReindexRequestCleaner();
        this.indexRecoveryLauncher = new IndexRecoveryLauncher();
        this.imageIOProviderScannerLauncher = new ImageIOProviderScannerLauncher();
        this.cacheWarmerLauncher = new CacheWarmerLauncher();
    }

    @Override
    public void start() {
        this.preActivationTimer = new StopWatch();
        DefaultInstrumentationListenerManager.startContext("startup");
        JiraDevSpeedTimer.run(this.getStartupName(), () -> {
            this.preDbLaunch();
            this.postDbLaunch();
        });
        DefaultIndexManager.flushThreadLocalSearchers();
        DefaultInstrumentationListenerManager.endContext();
    }

    private void preDbLaunch() {
        this.systemInfoLauncher.start();
        this.bootstrapContainerLauncher.start();
        this.startupChecklist.start();
        this.imageIOProviderScannerLauncher.start();
        this.preDbFailedPluginsLauncher.start();
    }

    private void postDbLaunch() {
        if (JiraStartupChecklist.startupOK()) {
            DatabaseConfigurationManager dbcm = (DatabaseConfigurationManager)ComponentAccessor.getComponentOfType(DatabaseConfigurationManager.class);
            ServletContext servletContext = ServletContextProvider.getServletContext();
            this.embeddedDatabaseServerLauncher.start();
            dbcm.doNowOrWhenDatabaseConfigured(() -> new DatabaseChecklistLauncher(dbcm, servletContext, this.jiraSystemProperties, this.johnsonProvider).start(), "Database Checklist Launcher");
            dbcm.doNowOrWhenDatabaseActivated(() -> {
                Collection events = this.johnsonProvider.getContainer().getEvents();
                if (events.isEmpty()) {
                    this.componentContainerLauncher.start();
                    this.databaseLauncher.start();
                    this.disasterRecoveryLauncher.earlyStart();
                    this.clusteringChecklistLauncher.start();
                    this.clusteringLauncher.start();
                    this.pluginSystemLauncher.start();
                    this.postDBActivated();
                } else {
                    log.error("Johnson events present; aborting: {}", (Object)events);
                }
            }, "Post database-configuration launchers");
        }
    }

    private void postDBActivated() {
        TenantManager tenantManager = (TenantManager)ComponentAccessor.getComponentOfType(TenantManager.class);
        boolean wasAlreadyTenanted = tenantManager.isTenanted();
        tenantManager.doNowOrWhenTenantArrives(() -> {
            Collection events = this.johnsonProvider.getContainer().getEvents();
            if (events.isEmpty()) {
                this.postTenantArrived(wasAlreadyTenanted);
            } else {
                log.error("Johnson events present; aborting: {}", (Object)events);
            }
        }, "Tenanted launchers");
    }

    private void postTenantArrived(boolean wasAlreadyTenanted) {
        if (wasAlreadyTenanted) {
            this.logPreActivationTime();
        }
        InstantUpgradeManager instantUpgradeManager = (InstantUpgradeManager)ComponentAccessor.getComponentOfType(InstantUpgradeManager.class);
        instantUpgradeManager.doNowOrWhenInstanceBecomesActive(() -> {
            Collection events = this.johnsonProvider.getContainer().getEvents();
            if (events.isEmpty()) {
                this.consistencyChecker.initialise(ServletContextProvider.getServletContext());
                this.reindexRequestCleaner.start();
                this.pluginSystemLauncher.lateStart();
                this.activeServicesLauncher.start();
                this.notificationInstanceKiller.deleteAfterDelay();
                this.disasterRecoveryLauncher.start();
                this.indexRecoveryLauncher.start();
                this.cacheWarmerLauncher.start();
                this.postDbFailedPluginsLauncher.start();
            } else {
                log.error("Johnson events present; aborting: {}", (Object)events);
            }
        }, "Late startup launchers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        log.info("Stopping launchers");
        StopWatch stopWatch = new StopWatch();
        ThreadDumper threadDumper = null;
        OpTimerFactory opTimerFactory = null;
        try {
            threadDumper = this.startDumper();
            this.clusteringLauncher.stop();
            this.activeServicesLauncher.stop();
            this.reindexRequestCleaner.stop();
            this.consistencyChecker.destroy(ServletContextProvider.getServletContext());
            this.pluginSystemLauncher.stop();
            this.databaseLauncher.stop();
            this.imageIOProviderScannerLauncher.stop();
            this.startupChecklist.stop();
            opTimerFactory = (OpTimerFactory)ComponentAccessor.getComponent(OpTimerFactory.class);
            this.componentContainerLauncher.stop();
            this.bootstrapContainerLauncher.stop();
            this.systemInfoLauncher.stop();
            this.preDbFailedPluginsLauncher.stop();
            this.postDbFailedPluginsLauncher.stop();
            this.embeddedDatabaseServerLauncher.stop();
        }
        finally {
            if (threadDumper != null) {
                threadDumper.cancelDump();
            }
        }
        this.cleanupAfterOurselves(opTimerFactory, stopWatch);
    }

    private void logPreActivationTime() {
        JiraTenancyCondition tenancyCondition = new JiraTenancyCondition(this.jiraSystemProperties);
        if (!tenancyCondition.isEnabled()) {
            return;
        }
        String logKey = "jira.launcher.start.preactivation.millis";
        String message = "JIRA early startup took {}s";
        long elapsedTime = this.preActivationTimer.getTotalTime();
        MDC.put((String)logKey, (Object)elapsedTime);
        log.info(message, (Object)(elapsedTime / 1000L));
        MDC.remove((String)logKey);
    }

    private void cleanupAfterOurselves(OpTimerFactory opTimerFactory, StopWatch stopWatch) {
        this.cleanupThreadLocals(opTimerFactory);
        this.logShutDownTime(stopWatch);
        LogManager.shutdown();
    }

    private void logShutDownTime(StopWatch stopWatch) {
        long elapsedTime = stopWatch.getTotalTime();
        String logKey = this.jiraSystemProperties.getBoolean("skip.plugin.system.shutdown") != false ? "jira.launcher.stop.instant.millis" : "jira.launcher.stop.millis";
        MDC.put((String)logKey, (Object)elapsedTime);
        log.info("JIRA launchers stopped in {}ms", (Object)elapsedTime);
        MDC.remove((String)logKey);
    }

    private ThreadDumper startDumper() {
        ThreadDumper threadDumper = new ThreadDumper(TimeUnit.MINUTES.toMillis(4L));
        if (this.jiraSystemProperties.isDevMode() || this.jiraSystemProperties.getBoolean("jira.dump").booleanValue()) {
            Thread thread = new Thread((Runnable)threadDumper, "Thread-dumping thread from " + this.getClass().getSimpleName());
            thread.setDaemon(true);
            thread.start();
        }
        return threadDumper;
    }

    private void cleanupThreadLocals(OpTimerFactory opTimerFactory) {
        Instrumentation.snapshotThreadLocalOperationsAndClear(opTimerFactory);
        RegisteredThreadLocals.reset();
        BruteForceThreadLocalCleanup.cleanUp((ClassLoader)this.getClass().getClassLoader());
    }

    private String getStartupName() {
        String jvmInputArguments = StringUtils.defaultString((String)RuntimeInformationFactory.getRuntimeInformation().getJvmInputArguments());
        boolean rebel = jvmInputArguments.contains("jrebel.jar");
        boolean debugMode = jvmInputArguments.contains("-Xdebug");
        return "jira.startup" + (debugMode ? ".debug" : ".run") + (rebel ? ".jrebel" : "");
    }
}

