/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.ofbiz.FieldMap;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationInstanceKiller {
    public static final String NOTIFICATION_INSTANCE_UPGRADE_DATE = "notification.instance.upgrade.date";
    private static final long DELAY = 2419200000L;
    private static final Logger log = LoggerFactory.getLogger(NotificationInstanceKiller.class);

    public void deleteAfterDelay() {
        String upgradeDateAsText = this.getApplicationProperties().getString(NOTIFICATION_INSTANCE_UPGRADE_DATE);
        if (upgradeDateAsText == null || upgradeDateAsText.isEmpty()) {
            return;
        }
        long timeToDie = Long.parseLong(upgradeDateAsText) + 2419200000L;
        if (System.currentTimeMillis() > timeToDie) {
            log.info("Starting a background thread to clear out obsolete NotificationInstance data ...");
            new Thread(new Assassin()).start();
        } else {
            log.info("Not deleting NotificationInstance table yet, will delete on first startup after " + new Date(timeToDie));
        }
    }

    private ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    private class Assassin
    implements Runnable {
        private Assassin() {
        }

        @Override
        public void run() {
            log.info("Deleting data from NotificationInstance.");
            for (int i = 1; i <= 17; ++i) {
                String type = "NOTIFICATION_" + i;
                log.info("Deleting type " + type + " from NotificationInstance.");
                int count = ComponentAccessor.getOfBizDelegator().removeByAnd("NotificationInstance", (Map)FieldMap.build((String)"type", (Object)type));
                log.info("Deleted " + count + " rows of type " + type + " from NotificationInstance.");
            }
            log.info("Deleting data from NotificationInstance completed successfully.");
            NotificationInstanceKiller.this.getApplicationProperties().setString(NotificationInstanceKiller.NOTIFICATION_INSTANCE_UPGRADE_DATE, null);
        }
    }
}

