/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template.velocity;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.template.velocity.VelocityEngineFactory;
import com.atlassian.jira.template.velocity.VelocityEngineInitializedEvent;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.apache.velocity.app.VelocityEngine;

public class InstrumentedVelocityEngineFactory
implements VelocityEngineFactory {
    private final VelocityEngineFactory velocityEngineFactory;
    private final EventPublisher eventPublisher;
    private final Clock clock;

    public InstrumentedVelocityEngineFactory(VelocityEngineFactory velocityEngineFactory, EventPublisher eventPublisher, Clock clock) {
        this.velocityEngineFactory = velocityEngineFactory;
        this.eventPublisher = eventPublisher;
        this.clock = clock;
    }

    @Override
    public VelocityEngine getEngine() {
        Instant start = this.clock.instant();
        VelocityEngine velocityEngine = this.velocityEngineFactory.getEngine();
        Duration initialization = Duration.between(start, this.clock.instant());
        this.eventPublisher.publish((Object)new VelocityEngineInitializedEvent(initialization));
        return velocityEngine;
    }
}

