/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.tenancy;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.tenancy.JiraTenantAccessor;
import com.atlassian.jira.tenancy.JiraTenantImpl;
import com.atlassian.jira.tenancy.TenancyCondition;
import com.atlassian.jira.tenancy.TenantManager;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTenantManager
implements TenantManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultTenantManager.class);
    private final ApplicationProperties applicationProperties;
    private final TenancyCondition tenancyCondition;
    private final JiraTenantAccessor jiraTenantAccessor;
    private final AtomicBoolean hasTaskRun = new AtomicBoolean(false);
    private final AtomicBoolean hasTenantArrived = new AtomicBoolean(false);
    private volatile AtomicReference<Runnable> task = new AtomicReference();
    private volatile String description;

    public DefaultTenantManager(ApplicationProperties applicationProperties, TenancyCondition tenancyCondition, JiraTenantAccessor jiraTenantAccessor) {
        this.applicationProperties = applicationProperties;
        this.tenancyCondition = tenancyCondition;
        this.jiraTenantAccessor = jiraTenantAccessor;
    }

    @Override
    public void doNowOrWhenTenantArrives(Runnable runnable, String description) {
        if (!this.task.compareAndSet(null, runnable)) {
            throw new IllegalStateException("Instance tenant task has already been registered");
        }
        this.description = description;
        if (this.isTenanted()) {
            log.info("Instance has a tenant. Now running [{}]", (Object)description);
            this.hasTaskRun.set(true);
            runnable.run();
        } else if (this.hasTenantArrived.get() && this.hasTaskRun.compareAndSet(false, true)) {
            try {
                log.info("Instance has a tenant. Now running [{}]", (Object)description);
                runnable.run();
            }
            catch (Exception e) {
                this.fatalJhonson(e);
            }
            catch (Error e) {
                this.fatalJhonson(e);
                throw e;
            }
        } else {
            log.info("A tenant has not yet arrived. Enqueuing [{}]", (Object)description);
            log.info("Awaiting a tenant via a landlord request");
        }
    }

    @Override
    public ServiceResult tenantArrived() {
        if (!this.isTenancyEnabled()) {
            return ServiceOutcomeImpl.error("Instance tenanting is NOT enabled, ignoring instance tenanting request.");
        }
        this.hasTenantArrived.set(true);
        if (this.task.get() != null) {
            if (this.hasTaskRun.compareAndSet(false, true)) {
                try {
                    log.info("Tenant arrived. Running [{}]", (Object)this.description);
                    this.task.get().run();
                    return ServiceOutcomeImpl.ok(null);
                }
                catch (Exception e) {
                    return this.fatalJhonson(e);
                }
                catch (Error e) {
                    this.fatalJhonson(e);
                    throw e;
                }
            }
            return ServiceOutcomeImpl.error("Instance is already tenanted, ignoring tenant arrival notification.");
        }
        return ServiceOutcomeImpl.ok("Instance is not yet ready to accept a tenant. It will be tenanted as soon as is ready.");
    }

    @Override
    public boolean isTenanted() {
        if (this.isTenancyEnabled()) {
            return this.jiraTenantAccessor.getAvailableTenants().iterator().hasNext();
        }
        return true;
    }

    @Override
    public void afterInstantiation() throws Exception {
        String baseUrl;
        if (this.isTenancyEnabled() && (baseUrl = this.applicationProperties.getDefaultBackedText("jira.baseurl")) != null) {
            this.jiraTenantAccessor.addTenant(new JiraTenantImpl(this.getBaseUrlWithoutProtocol(baseUrl)));
        }
    }

    private boolean isTenancyEnabled() {
        return this.tenancyCondition.isEnabled();
    }

    private String getBaseUrlWithoutProtocol(String baseUrl) {
        try {
            URL url = new URL(baseUrl);
            return url.getAuthority() + url.getPath();
        }
        catch (Exception e) {
            return baseUrl;
        }
    }

    private ServiceOutcomeImpl fatalJhonson(Throwable e) {
        JohnsonProvider johnsonProvider = (JohnsonProvider)ComponentAccessor.getComponentOfType(JohnsonProvider.class);
        log.error("Unable to tenant JIRA", e);
        String errorMessage = "Unexpected exception when tenant arrived. This JIRA instance will not be able to recover. Please check the logs for details.";
        johnsonProvider.getContainer().addEvent(new Event(EventType.get((String)"startup-unexpected"), errorMessage, EventLevel.get((String)"fatal")));
        return ServiceOutcomeImpl.error(errorMessage);
    }
}

