/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6328
extends AbstractDelayableUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build6328.class);
    private Statement statement;
    private static final Map<String, List<String>> TARGETS = ImmutableMap.builder().put((Object)"JQRTZTriggers", UpgradeTask_Build6328.fields("nextFireTime", "prevFireTime", "startTime", "endTime")).put((Object)"JQRTZSimpleTriggers", UpgradeTask_Build6328.fields("repeatCount", "repeatInterval", "timesTriggered")).put((Object)"JQRTZSimplePropTriggers", UpgradeTask_Build6328.fields("long_prop_1", "long_prop_2")).put((Object)"JQRTZFiredTriggers", UpgradeTask_Build6328.fields("firedTime", "schedTime")).put((Object)"JQRTZSchedulerState", UpgradeTask_Build6328.fields("lastCheckinTime", "checkinInterval")).build();

    @Override
    public String getBuildNumber() {
        return "6328";
    }

    @Override
    public String getShortDescription() {
        return "Widen Quartz time fields from NUMBER(13) to NUMBER(18) on Oracle";
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return true;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        if (setupMode || !this.isORACLE()) {
            return;
        }
        try (Connection conn = this.getDatabaseConnection();){
            this.alterAllEntities(conn);
        }
    }

    private void alterAllEntities(Connection conn) throws SQLException, GenericEntityException {
        this.statement = conn.createStatement();
        try {
            this.alterAllEntities();
        }
        finally {
            Statement oldStatement = this.statement;
            this.statement = null;
            oldStatement.close();
        }
    }

    private void alterAllEntities() throws SQLException, GenericEntityException {
        for (Map.Entry<String, List<String>> entry : TARGETS.entrySet()) {
            this.alterEntityFields(entry.getKey(), entry.getValue());
        }
    }

    private void alterEntityFields(String entityName, List<String> fieldNames) throws SQLException, GenericEntityException {
        ModelEntity modelEntity = UpgradeTask_Build6328.getOfBizDelegator().getModelReader().getModelEntity(entityName);
        String tableName = this.convertToSchemaTableName(modelEntity.getPlainTableName());
        for (String fieldName : fieldNames) {
            String columnName = modelEntity.getField(fieldName).getColName();
            this.execute("ALTER TABLE " + tableName + " MODIFY (" + columnName + " NUMBER(18))");
        }
    }

    private int execute(String sql) throws SQLException {
        LOG.debug(sql);
        this.statement.execute(sql);
        return this.statement.getUpdateCount();
    }

    private static List<String> fields(String ... fields) {
        return ImmutableList.copyOf((Object[])fields);
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6327";
    }
}

