/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.appconsistency.db.TableColumnCheckResult;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.atlassian.jira.upgrade.util.UpgradeUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build70108
extends AbstractDelayableUpgradeTask {
    private static final String BUILD_NUMBER = "70108";
    private static final String REINDEX_TABLE = "reindex_request";
    private static final String QUERY_COLUMN = "query";
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build70108.class);
    private final EntityEngine entityEngine;

    @Inject
    public UpgradeTask_Build70108(EntityEngine entityEngine) {
        this.entityEngine = entityEngine;
    }

    @Override
    public String getBuildNumber() {
        return BUILD_NUMBER;
    }

    @Override
    public String getShortDescription() {
        return "Deleting query column from reindex-request.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        TableColumnCheckResult columnCheckResult = new TableColumnCheckResult(REINDEX_TABLE, QUERY_COLUMN);
        List<TableColumnCheckResult> tableColumnCheckResults = Collections.singletonList(columnCheckResult);
        UpgradeUtils.doColumnsOrTablesExist(tableColumnCheckResults);
        if (columnCheckResult.isExists()) {
            this.removeQueryColumn();
        }
    }

    private void removeQueryColumn() {
        try (Connection connection = this.getDatabaseConnection();){
            String sql = String.format("alter table %s drop column %s", this.convertToSchemaTableName(REINDEX_TABLE), QUERY_COLUMN);
            try (PreparedStatement ps = connection.prepareStatement(sql);){
                ps.execute();
            }
        }
        catch (SQLException e) {
            log.error("An exception occurred when dropping the query column", (Throwable)e);
        }
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }
}

