/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRole;
import com.atlassian.jira.upgrade.tasks.role.GlobalPermissionDao;
import com.atlassian.jira.upgrade.tasks.role.Jira6xServiceDeskLicenseProvider;
import com.atlassian.jira.upgrade.tasks.role.LicenseUtils;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import com.atlassian.jira.upgrade.tasks.role.MigrationGroupService;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.MigrationValidator;
import com.atlassian.jira.upgrade.tasks.role.UserWithPermissions;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationValidatorImpl
extends MigrationValidator {
    private static final Logger log = LoggerFactory.getLogger(MigrationValidatorImpl.class);
    private final GlobalPermissionDao globalPermissionDao;
    private final Jira6xServiceDeskLicenseProvider licenseSupplier;
    private final MigrationGroupService migrationGroupService;

    MigrationValidatorImpl(GlobalPermissionDao globalPermissionDao, Jira6xServiceDeskLicenseProvider licenseSupplier, MigrationGroupService migrationGroupService) {
        this.globalPermissionDao = (GlobalPermissionDao)Assertions.notNull((String)"globalPermissionDao", (Object)globalPermissionDao);
        this.licenseSupplier = licenseSupplier;
        this.migrationGroupService = migrationGroupService;
    }

    @Override
    void validate(MigrationState original, MigrationState resulting) {
        Assertions.notNull((String)"original", (Object)original);
        Assertions.notNull((String)"resulting", (Object)resulting);
        this.verifyAdministrators(original, resulting);
        this.verifyUsersFor(original, resulting, ApplicationKeys.CORE, ApplicationKeys.SOFTWARE);
        this.validateServiceDesk(original, resulting);
    }

    private void validateServiceDesk(MigrationState original, MigrationState resulting) {
        Option<LicenseUtils.ServiceDeskLicenseType> agentBasedPricing = this.getServiceDeskMigrationType();
        if (agentBasedPricing.isEmpty()) {
            this.validateServiceDeskRoleHasNoEscalations(original, resulting);
        } else {
            switch ((LicenseUtils.ServiceDeskLicenseType)((Object)agentBasedPricing.get())) {
                case AgentBasedPricing: {
                    this.validateServiceDeskAgents(original, resulting);
                    break;
                }
                case TierBasedPricing: {
                    this.verifyUsersFor(original, resulting, ApplicationKeys.SERVICE_DESK);
                    break;
                }
                default: {
                    throw new MigrationValidationFailedException("Unable to determine migration type.");
                }
            }
        }
    }

    private void verifyAdministrators(MigrationState original, MigrationState resulting) {
        Set invariantDefaultGroups = (Set)original.applicationRoles().asMap().values().stream().flatMap(role -> role.defaultGroups().stream()).collect(CollectorsUtil.toImmutableSet());
        Set defaultGroups = (Set)resulting.applicationRoles().asMap().values().stream().flatMap(role -> role.defaultGroups().stream()).collect(CollectorsUtil.toImmutableSet());
        Sets.SetView newDefaultGroups = Sets.difference((Set)defaultGroups, (Set)invariantDefaultGroups);
        Sets.SetView defaultAdminGroups = Sets.intersection(this.globalPermissionDao.groupsWithAdminPermission(), (Set)newDefaultGroups);
        if (!defaultAdminGroups.isEmpty()) {
            Set groupNames = (Set)defaultAdminGroups.stream().map(Group::getName).collect(CollectorsUtil.toImmutableSet());
            log.error("Administrator groups have become default: " + String.join((CharSequence)", ", groupNames));
            throw new MigrationValidationFailedException("Administrator groups have become default group in application role:" + String.join((CharSequence)", ", groupNames));
        }
        Set applicationGroups = (Set)resulting.applicationRoles().asMap().values().stream().flatMap(role -> role.groups().stream()).collect(CollectorsUtil.toImmutableSet());
        Sets.SetView droppedAdminGroups = Sets.difference(this.globalPermissionDao.groupsWithAdminPermission(), (Set)applicationGroups);
        if (!droppedAdminGroups.isEmpty()) {
            log.warn("The following administrator groups were not migrated properly: " + droppedAdminGroups.stream().map(Group::getName).collect(Collectors.joining(", ")));
        }
    }

    private void verifyUsersFor(MigrationState original, MigrationState resulting, ApplicationKey ... keys) {
        Sets.SetView loginGroups = Sets.union(this.globalPermissionDao.groupsWithUsePermission(), this.globalPermissionDao.groupsWithAdminPermission());
        Sets.SetView default6xGroups = Sets.difference((Set)loginGroups, this.globalPermissionDao.groupsWithAdminPermission());
        for (ApplicationKey applicationKey : keys) {
            ApplicationRole originalApp = (ApplicationRole)original.applicationRoles().get(applicationKey).getOrElse((Object)ApplicationRole.forKey(applicationKey));
            ApplicationRole resultingApp = (ApplicationRole)resulting.applicationRoles().get(applicationKey).getOrElse((Object)ApplicationRole.forKey(applicationKey));
            this.verifyUseGroupsWithoutAdminMigratedToDefaultGroups((Set<Group>)default6xGroups, applicationKey, resultingApp);
            this.verifyUseAndAdminGroupsMigratedToApplicationGroups((Set<Group>)loginGroups, applicationKey, resultingApp);
            this.validateDefaultGroupsNotExceeding6xGroups((Set<Group>)default6xGroups, applicationKey, originalApp, resultingApp);
            this.validateApplicationGroupsNotExceeding6xGroups((Set<Group>)loginGroups, applicationKey, originalApp, resultingApp);
        }
    }

    private void validateServiceDeskAgents(MigrationState original, MigrationState resulting) {
        Set<Group> sdLoginGroups = this.globalPermissionDao.groupsWithSdAgentPermission();
        Sets.SetView sdDefaultGroups = Sets.difference(sdLoginGroups, this.globalPermissionDao.groupsWithAdminPermission());
        ApplicationKey sdAppKey = ApplicationKeys.SERVICE_DESK;
        ApplicationRole resultingSdApp = (ApplicationRole)resulting.applicationRoles().get(sdAppKey).getOrElse((Object)ApplicationRole.forKey(sdAppKey));
        ApplicationRole originalSdApp = (ApplicationRole)original.applicationRoles().get(sdAppKey).getOrElse((Object)ApplicationRole.forKey(sdAppKey));
        this.verifyUseGroupsWithoutAdminMigratedToDefaultGroups((Set<Group>)sdDefaultGroups, sdAppKey, resultingSdApp);
        this.verifyUseAndAdminGroupsMigratedToApplicationGroups(sdLoginGroups, sdAppKey, resultingSdApp);
        this.validateDefaultGroupsNotExceeding6xGroups((Set<Group>)sdDefaultGroups, sdAppKey, originalSdApp, resultingSdApp);
        this.validateApplicationGroupsNotExceeding6xGroups(sdLoginGroups, sdAppKey, originalSdApp, resultingSdApp);
        for (Group sdGroup : Sets.difference(resultingSdApp.groups(), originalSdApp.groups())) {
            for (UserWithPermissions user2 : this.migrationGroupService.getUsersInGroup(sdGroup)) {
                if (user2.canLogin()) continue;
                String message = "Service Desk agent: " + user2.getUser().getName() + " is part of " + sdGroup.getName() + " group";
                log.error(message);
                throw new MigrationValidationFailedException(message);
            }
        }
        for (Group sdGroup : Sets.difference(sdLoginGroups, resultingSdApp.groups())) {
            String message = "ABP group " + sdGroup.getName() + " did not migrate to Service Desk with following Users:" + this.migrationGroupService.getUsersInGroup(sdGroup).stream().map(user -> user.getUser().getName()).collect(Collectors.joining(",", " ", "."));
            log.warn(message);
        }
    }

    private void validateApplicationGroupsNotExceeding6xGroups(Set<Group> loginGroups, ApplicationKey applicationKey, ApplicationRole originalApp, ApplicationRole resultingApp) {
        Sets.SetView addedAppGroup = Sets.difference((Set)Sets.difference(resultingApp.groups(), originalApp.groups()), loginGroups);
        if (!addedAppGroup.isEmpty()) {
            String errorMessage = "Following application groups for " + applicationKey.value() + " did not have USE or ADMINISTRATOR permission: " + addedAppGroup.stream().map(Group::getName).collect(Collectors.joining(", "));
            log.error(errorMessage);
            throw new MigrationValidationFailedException(errorMessage);
        }
    }

    private void validateDefaultGroupsNotExceeding6xGroups(Set<Group> default6xGroups, ApplicationKey applicationKey, ApplicationRole originalApp, ApplicationRole resultingApp) {
        Sets.SetView addedDefaultGroups = Sets.difference((Set)Sets.difference(resultingApp.defaultGroups(), originalApp.defaultGroups()), default6xGroups);
        if (!addedDefaultGroups.isEmpty()) {
            String errorMessage = "Following default groups for " + applicationKey.value() + " did not have USE permission: " + addedDefaultGroups.stream().map(Group::getName).collect(Collectors.joining(", "));
            log.error(errorMessage);
            throw new MigrationValidationFailedException(errorMessage);
        }
    }

    private void verifyUseAndAdminGroupsMigratedToApplicationGroups(Set<Group> loginGroups, ApplicationKey applicationKey, ApplicationRole resultingApp) {
        Sets.SetView droppedGroups = Sets.difference(loginGroups, resultingApp.groups());
        if (!droppedGroups.isEmpty()) {
            log.warn("Following Use/Admin groups were not migrated as application group to " + applicationKey.value() + ": " + droppedGroups.stream().map(Group::getName).collect(Collectors.joining(", ")));
        }
    }

    private void verifyUseGroupsWithoutAdminMigratedToDefaultGroups(Set<Group> default6xGroups, ApplicationKey applicationKey, ApplicationRole resultingApp) {
        Sets.SetView droppedDefaultGroups = Sets.difference(default6xGroups, resultingApp.defaultGroups());
        if (!droppedDefaultGroups.isEmpty()) {
            log.warn("Following USE groups were not migrated as default to " + applicationKey.value() + ": " + droppedDefaultGroups.stream().map(Group::getName).collect(Collectors.joining(", ")));
        }
    }

    private void validateServiceDeskRoleHasNoEscalations(MigrationState original, MigrationState resulting) {
        Option<ApplicationRole> serviceDeskRole = resulting.applicationRoles().get(ApplicationKeys.SERVICE_DESK);
        if (serviceDeskRole.isDefined()) {
            ApplicationRole originalApp = (ApplicationRole)original.applicationRoles().get(ApplicationKeys.SERVICE_DESK).getOrElse((Object)ApplicationRole.forKey(ApplicationKeys.SERVICE_DESK));
            Sets.SetView appGroups = Sets.difference(((ApplicationRole)serviceDeskRole.get()).groups(), originalApp.groups());
            Sets.SetView defaultAppGroups = Sets.difference(((ApplicationRole)serviceDeskRole.get()).defaultGroups(), originalApp.defaultGroups());
            if (!appGroups.isEmpty() || !defaultAppGroups.isEmpty()) {
                String message = "Service Desk appears to have groups when it is not licensed: " + appGroups.stream().map(Group::getName).collect(Collectors.joining(", ")) + " [default]:" + defaultAppGroups.stream().map(Group::getName).collect(Collectors.joining(", "));
                throw new MigrationValidationFailedException(message);
            }
        }
    }

    private Option<LicenseUtils.ServiceDeskLicenseType> getServiceDeskMigrationType() {
        return this.licenseSupplier.serviceDeskLicense().map(LicenseUtils::determineServiceDeskLicenseType);
    }

    static class MigrationValidationFailedException
    extends MigrationFailedException {
        MigrationValidationFailedException(String message) {
            super(message);
        }
    }
}

