/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.GroupWithAttributes;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRole;
import com.atlassian.jira.upgrade.tasks.role.AuditEntry;
import com.atlassian.jira.upgrade.tasks.role.AuditEntrySeverity;
import com.atlassian.jira.upgrade.tasks.role.GlobalPermissionDao;
import com.atlassian.jira.upgrade.tasks.role.MigrationChangedValue;
import com.atlassian.jira.upgrade.tasks.role.MigrationGroupService;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.MigrationTask;
import com.atlassian.jira.upgrade.tasks.role.UserWithPermissions;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MoveJira6xABPServiceDeskPermissions
extends MigrationTask {
    public static final String PROPERTY_SERVICEDESK_NOT_MIGRATED_GROUPS = "renaissance.migration.servicedesk.not.migrated.groups";
    private static final String GROUP_ATTR_SERVICE_DESK = "synch.created.by.jira.service.desk";
    private static final String GROUP_ATTR_SERVICE_DESK_VALUE = "synch.created.by.jira.service.desk";
    private static final Group GROUP_SD_AGENTS = new ImmutableGroup("service-desk-agents");
    private final MigrationGroupService migrationGroupService;
    private final GlobalPermissionDao globalPermissionDao;
    private final ApplicationProperties applicationProperties;

    MoveJira6xABPServiceDeskPermissions(MigrationGroupService migrationGroupService, GlobalPermissionDao globalPermissionDao, ApplicationProperties applicationProperties) {
        this.migrationGroupService = migrationGroupService;
        this.globalPermissionDao = globalPermissionDao;
        this.applicationProperties = applicationProperties;
    }

    @Override
    MigrationState migrate(MigrationState state, boolean licenseSuppliedByUser) {
        Set<Group> sdAgentGroups = this.globalPermissionDao.groupsWithSdAgentPermission();
        ArrayList<String> notMigratedGroups = new ArrayList<String>();
        for (Group sdAgentGroup : sdAgentGroups) {
            Pair<MigrationState, Boolean> result = this.checkGroupAndMigrate(sdAgentGroup, state);
            if (!((Boolean)result.second()).booleanValue()) {
                notMigratedGroups.add(sdAgentGroup.getName());
            }
            state = (MigrationState)result.first();
        }
        return state.withAfterSaveTask(() -> this.saveNotMigratedGroups(notMigratedGroups));
    }

    private Pair<MigrationState, Boolean> checkGroupAndMigrate(Group sdAgentGroup, MigrationState state) {
        Set<UserWithPermissions> usersInAgentGroup = this.migrationGroupService.getUsersInGroup(sdAgentGroup);
        HashSet<String> agentsWithoutUsePermission = new HashSet<String>();
        boolean allUsersHaveUse = true;
        boolean anyUserHasUse = false;
        for (UserWithPermissions user : usersInAgentGroup) {
            boolean hasUse = user.hasAdminPermission() || user.hasUsePermission();
            allUsersHaveUse &= hasUse;
            anyUserHasUse |= hasUse;
            if (hasUse) continue;
            agentsWithoutUsePermission.add(user.getUser().getName());
        }
        if (allUsersHaveUse) {
            MigrationState migrationState = state.changeApplicationRole(ApplicationKeys.SERVICE_DESK, role -> this.migrateGroup((ApplicationRole)role, sdAgentGroup));
            MigrationChangedValue changedValue = new MigrationChangedValue(sdAgentGroup.getName(), "USE (permission), Agent (permission)", ApplicationKeys.SERVICE_DESK.value() + " (role)");
            AuditEntry event = new AuditEntry(this.getClass(), "Group added to Service Desk: " + sdAgentGroup.getName(), "Group was migrated as all users have both JIRA USE and Agent permissions", AssociatedItem.Type.APPLICATION_ROLE, ApplicationKeys.SERVICE_DESK.value(), true, changedValue);
            return Pair.of((Object)migrationState.log(event), (Object)true);
        }
        int numUsersInAgentsGroup = usersInAgentGroup.size();
        if (anyUserHasUse) {
            StringBuilder builder = new StringBuilder().append("Service Desk Migration - cannot add Service Desk application role to group: '").append(sdAgentGroup.getName()).append("'\n").append("Group contains users with misconfigured permissions - not all users in the group are ").append("able to log in to JIRA, migration would cause privilege escalation.\n").append("To fix this issue, disable these users or remove them from the group ").append("then associate that group with the Service Desk application.\n").append("Agents without use permission:\n");
            String sep = "";
            for (String userName : agentsWithoutUsePermission) {
                builder.append(sep).append(userName);
                sep = ", ";
            }
            MigrationState result = state.log(new AuditEntry(MoveJira6xABPServiceDeskPermissions.class, "Service Desk not migrated", builder.toString(), AssociatedItem.Type.APPLICATION_ROLE, null, true, Collections.emptyList(), AuditEntrySeverity.WARNING));
            return Pair.of((Object)result, (Object)false);
        }
        MigrationState result = state.log(new AuditEntry(MoveJira6xABPServiceDeskPermissions.class, "Service Desk not migrated", "There are " + numUsersInAgentsGroup + " users with Service Desk Agent permission who" + " do not have JIRA USE permission. In order to avoid allowing these users to log" + " in, the group '" + sdAgentGroup.getName() + "' has not been assigned to" + " Service Desk.", AssociatedItem.Type.APPLICATION_ROLE));
        return Pair.of((Object)result, (Object)true);
    }

    private ApplicationRole migrateGroup(ApplicationRole applicationRole, Group sdAgentGroup) {
        ApplicationRole roleWithGroup = applicationRole.addGroup(sdAgentGroup);
        if (this.shouldSetGroupAsDefault(sdAgentGroup)) {
            roleWithGroup = roleWithGroup.addGroupAsDefault(sdAgentGroup);
        }
        return roleWithGroup;
    }

    private boolean shouldSetGroupAsDefault(Group sdAgentGroup) {
        GroupWithAttributes groupWithAttributes = this.migrationGroupService.getGroupWithAttributes(sdAgentGroup);
        boolean groupHasAdmin = this.globalPermissionDao.groupsWithAdminPermission().contains(sdAgentGroup);
        return !groupHasAdmin && groupWithAttributes != null && GROUP_SD_AGENTS.equals((Object)sdAgentGroup) && "synch.created.by.jira.service.desk".equals(groupWithAttributes.getValue("synch.created.by.jira.service.desk"));
    }

    private void saveNotMigratedGroups(List<String> groups) {
        if (groups.isEmpty()) {
            this.applicationProperties.setString(PROPERTY_SERVICEDESK_NOT_MIGRATED_GROUPS, null);
        } else {
            this.applicationProperties.setString(PROPERTY_SERVICEDESK_NOT_MIGRATED_GROUPS, Joiner.on((String)", ").join(groups));
        }
    }
}

