/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.user.UserHistoryStore;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserHistoryDatabaseCompactor
implements Startable,
JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(UserHistoryDatabaseCompactor.class);
    private static final long DAILY = TimeUnit.DAYS.toMillis(1L);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)UserHistoryDatabaseCompactor.class.getName());
    private static final JobId JOB_ID = JobId.of((String)UserHistoryDatabaseCompactor.class.getName());
    private final UserHistoryStore userHistoryStore;

    public UserHistoryDatabaseCompactor(UserHistoryStore userHistoryStore) {
        this.userHistoryStore = userHistoryStore;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            Long removeThreshold = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(90L);
            this.userHistoryStore.removeHistoryOlderThan(removeThreshold);
        }
        catch (Exception ex) {
            LOG.warn("Exception occurred when running " + JOB_RUNNER_KEY + " job.", (Throwable)ex);
            return JobRunnerResponse.failed((Throwable)ex);
        }
        return JobRunnerResponse.success();
    }

    public void start() throws Exception {
        SchedulerService scheduler = (SchedulerService)ComponentAccessor.getComponent(SchedulerService.class);
        scheduler.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)DAILY, null));
        scheduler.scheduleJob(JOB_ID, jobConfig);
    }
}

