/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.GlobalUserPreferencesUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class GlobalUserPreferencesUtilImpl
implements GlobalUserPreferencesUtil {
    private final OfBizDelegator ofBizDelegator;
    private final UserPreferencesManager userPreferencesManager;

    public GlobalUserPreferencesUtilImpl(OfBizDelegator ofBizDelegator, UserPreferencesManager userPreferencesManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.userPreferencesManager = userPreferencesManager;
    }

    @Override
    public long getTotalUpdateUserCountMailMimeType(String mimetype) {
        List<GenericValue> valExternalEntity = this.getEntriesForMailWithMimetype(mimetype);
        return valExternalEntity.size();
    }

    @Override
    public void updateUserMailMimetypePreference(String mimetype) throws GenericEntityException {
        List<GenericValue> vals = this.getEntriesForMailWithMimetype(mimetype);
        ArrayList keys = Lists.newArrayListWithCapacity((int)vals.size());
        for (GenericValue genericValue : vals) {
            keys.add(genericValue.getLong("id"));
        }
        this.ofBizDelegator.bulkUpdateByPrimaryKey("OSPropertyString", (Map)FieldMap.build((String)"value", (Object)mimetype), (List)keys);
        this.userPreferencesManager.clearCache();
    }

    private List<GenericValue> getEntriesForMailWithMimetype(String mimetype) {
        String updateMimetype = mimetype.equalsIgnoreCase("html") ? "text" : "html";
        List vals = this.ofBizDelegator.findByAnd("OSUserPropertySetView", (Map)FieldMap.build((String)"propertyKey", (Object)"user.notifications.mimetype", (String)"entityName", (Object)Entity.APPLICATION_USER.getEntityName()));
        ArrayList matches = Lists.newArrayListWithCapacity((int)vals.size());
        for (GenericValue genericValue : vals) {
            if (!updateMimetype.equals(genericValue.getString("propertyValue"))) continue;
            matches.add(genericValue);
        }
        return matches;
    }
}

