/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.ofbiz.core.entity.DelegatorInterface;

public class UserKeyStoreImpl
implements UserKeyStore {
    private static final String LOWER_USER_NAME = "lowerUserName";
    private final EntityEngine entityEngine;
    private final OfBizDelegator ofBizDelegator;
    private final DelegatorInterface delegatorInterface;
    private final Cache<LazyCacheKey<String, ApplicationUserEntity>, CacheObject<ApplicationUserEntity>> keyToUserCache;
    private final Cache<LazyCacheKey<String, ApplicationUserEntity>, CacheObject<ApplicationUserEntity>> usernameToUserCache;
    private final Cache<LazyCacheKey<Long, ApplicationUserEntity>, CacheObject<ApplicationUserEntity>> idToUserCache;

    public UserKeyStoreImpl(EntityEngine entityEngine, OfBizDelegator ofBizDelegator, DelegatorInterface delegatorInterface, EventPublisher eventPublisher, CacheManager cacheManager) {
        this.entityEngine = entityEngine;
        this.ofBizDelegator = ofBizDelegator;
        this.delegatorInterface = delegatorInterface;
        this.keyToUserCache = cacheManager.getCache(UserKeyStoreImpl.class.getName() + ".keyToUserCache", this.lazyLoader(key -> (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual("userKey", (String)key).runWith(entityEngine).singleValue()));
        this.usernameToUserCache = cacheManager.getCache(UserKeyStoreImpl.class.getName() + ".usernameToUserCache", this.lazyLoader(username -> (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual(LOWER_USER_NAME, (String)username).runWith(entityEngine).singleValue()));
        this.idToUserCache = cacheManager.getCache(UserKeyStoreImpl.class.getName() + ".idToUserCache", this.lazyLoader(id -> (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual("id", (Long)id).runWith(entityEngine).singleValue()));
        this.buildCache();
        eventPublisher.register((Object)this);
    }

    private <K, V> CacheLoader<LazyCacheKey<K, V>, CacheObject<V>> lazyLoader(Function<K, V> loader) {
        return cacheKey -> Optional.ofNullable(((LazyCacheKey)cacheKey).value).map(CacheObject::wrap).orElseGet(() -> Optional.ofNullable(loader.apply(((LazyCacheKey)cacheKey).key)).map(CacheObject::wrap).orElse(CacheObject.NULL()));
    }

    @Override
    public String getUsernameForKey(String key) {
        return UserKeyStoreImpl.fromCache(this.keyToUserCache, key).map(ApplicationUserEntity::getUsername).orElse(null);
    }

    @Override
    public String getKeyForUsername(String username) {
        return UserKeyStoreImpl.fromCache(this.usernameToUserCache, IdentifierUtils.toLowerCase((String)username)).map(ApplicationUserEntity::getKey).orElse(null);
    }

    @Override
    public Long getIdForUserKey(String userkey) {
        return UserKeyStoreImpl.fromCache(this.keyToUserCache, userkey).map(ApplicationUserEntity::getId).orElse(null);
    }

    @Override
    public Optional<ApplicationUserEntity> getUserForId(Long id) {
        return UserKeyStoreImpl.fromCache(this.idToUserCache, id);
    }

    @Override
    public Optional<ApplicationUserEntity> getUserForKey(String key) {
        return UserKeyStoreImpl.fromCache(this.keyToUserCache, key);
    }

    @Override
    public Optional<ApplicationUserEntity> getUserForUsername(String username) {
        return UserKeyStoreImpl.fromCache(this.usernameToUserCache, IdentifierUtils.toLowerCase((String)username));
    }

    @Override
    public void renameUser(String oldUsername, String newUsername) {
        oldUsername = IdentifierUtils.toLowerCase((String)oldUsername);
        newUsername = IdentifierUtils.toLowerCase((String)newUsername);
        ApplicationUserEntity user = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual(LOWER_USER_NAME, oldUsername).runWith(this.ofBizDelegator).singleValue();
        if (user == null) {
            throw new IllegalStateException("Trying to rename user '" + oldUsername + "' but no user key is mapped.");
        }
        this.entityEngine.execute(Update.into(Entity.APPLICATION_USER).set(LOWER_USER_NAME, newUsername).whereEqual("userKey", user.getKey()));
        this.keyToUserCache.remove(LazyCacheKey.cacheKey(user.getKey()));
        this.usernameToUserCache.remove(LazyCacheKey.cacheKey(newUsername));
        this.usernameToUserCache.remove(LazyCacheKey.cacheKey(oldUsername));
        this.idToUserCache.remove(LazyCacheKey.cacheKey(user.getId()));
    }

    @Override
    public String ensureUniqueKeyForNewUser(String username) {
        String lowerUsername = IdentifierUtils.toLowerCase((String)((String)Assertions.notNull((String)"username", (Object)username)));
        ApplicationUserEntity applicationUserEntity = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual(LOWER_USER_NAME, lowerUsername).runWith(this.entityEngine).singleValue();
        if (applicationUserEntity != null) {
            return applicationUserEntity.getKey();
        }
        applicationUserEntity = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual("userKey", lowerUsername).runWith(this.entityEngine).singleValue();
        if (applicationUserEntity == null) {
            FieldMap fieldValues = FieldMap.build((String)"userKey", (Object)lowerUsername).add(LOWER_USER_NAME, (Object)lowerUsername);
            this.ofBizDelegator.createValue(Entity.APPLICATION_USER.getEntityName(), (Map)fieldValues);
            this.usernameToUserCache.remove(LazyCacheKey.cacheKey(lowerUsername));
            this.keyToUserCache.remove(LazyCacheKey.cacheKey(lowerUsername));
            return lowerUsername;
        }
        Long id = this.delegatorInterface.getNextSeqId(Entity.APPLICATION_USER.getEntityName());
        String userkey = "ID" + id;
        FieldMap fieldValues = FieldMap.build((String)"id", (Object)id).add("userKey", (Object)userkey).add(LOWER_USER_NAME, (Object)lowerUsername);
        this.ofBizDelegator.createValue(Entity.APPLICATION_USER.getEntityName(), (Map)fieldValues);
        this.usernameToUserCache.remove(LazyCacheKey.cacheKey(lowerUsername));
        this.keyToUserCache.remove(LazyCacheKey.cacheKey(userkey));
        return userkey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String removeByKey(String key) {
        if (key == null) {
            return null;
        }
        try {
            ApplicationUserEntity user = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual("userKey", key).runWith(this.entityEngine).singleValue();
            if (user != null) {
                Delete.from(Entity.APPLICATION_USER).whereEqual("userKey", key).execute(this.entityEngine);
                this.usernameToUserCache.remove(LazyCacheKey.cacheKey(user.getUsername()));
                this.idToUserCache.remove(LazyCacheKey.cacheKey(user.getId()));
                String string = user.getUsername();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.keyToUserCache.remove(LazyCacheKey.cacheKey(key));
        }
    }

    private void buildCache() {
        List users = Select.from(Entity.APPLICATION_USER).runWith(this.entityEngine).asList();
        for (ApplicationUserEntity user : users) {
            this.keyToUserCache.get(new LazyCacheKey<String, ApplicationUserEntity>(user.getKey(), user));
            this.usernameToUserCache.get(new LazyCacheKey<String, ApplicationUserEntity>(user.getUsername(), user));
            this.idToUserCache.get(new LazyCacheKey<Long, ApplicationUserEntity>(user.getId(), user));
        }
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.keyToUserCache.removeAll();
        this.usernameToUserCache.removeAll();
        this.idToUserCache.removeAll();
        this.buildCache();
    }

    private static <K, V> Optional<V> fromCache(Cache<LazyCacheKey<K, V>, CacheObject<V>> cache, K key) {
        return key != null ? Optional.ofNullable(((CacheObject)cache.get(LazyCacheKey.cacheKey(key))).getValue()) : Optional.empty();
    }

    @VisibleForTesting
    static class LazyCacheKey<K, V>
    implements Serializable {
        private final K key;
        private final V value;

        @VisibleForTesting
        LazyCacheKey(@Nonnull K key, @Nullable V value) {
            this.key = key;
            this.value = value;
        }

        public static <K, V> LazyCacheKey<K, V> cacheKey(K key) {
            return new LazyCacheKey<K, Object>(key, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LazyCacheKey that = (LazyCacheKey)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

