/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system.check;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.util.system.check.I18nMessage;
import com.atlassian.jira.util.system.check.SystemEnvironmentCheck;
import com.atlassian.jira.web.util.HelpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRA12525Check
implements SystemEnvironmentCheck {
    @Override
    public I18nMessage getWarningMessage() {
        try {
            if (!JiraSystemProperties.isDecodeMailParameters()) {
                HelpUtil helpUtil = new HelpUtil();
                I18nMessage warning = new I18nMessage("admin.warning.mail.decorateparameter");
                warning.addParameter("mail.mime.decodeparameters");
                warning.setLink(helpUtil.getHelpPath("decodeparameters").getUrl());
                return warning;
            }
        }
        catch (Exception e) {
            Logger log = LoggerFactory.getLogger(JRA12525Check.class);
            log.error("Error occured while checking e-mail properties: " + e.getMessage() + ". JIRA will continue starting.", (Throwable)e);
        }
        return null;
    }
}

