/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.roles;

import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorComparator;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.roles.AbstractRoleActors;
import com.atlassian.plugin.PluginAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class ViewProjectRoleActors
extends AbstractRoleActors {
    private final ProjectRoleService projectRoleService;
    private final ProjectManager projectManager;
    private Long projectId;

    public ViewProjectRoleActors(ProjectRoleService projectRoleService, ProjectManager projectManager, ProjectFactory projectFactory, PluginAccessor pluginAccessor) {
        super(projectRoleService, pluginAccessor);
        this.projectRoleService = projectRoleService;
        this.projectManager = projectManager;
        ProjectFactory projectFactory1 = projectFactory;
    }

    protected String doExecute() throws Exception {
        if (!this.projectRoleService.hasProjectRolePermission(this.getProject())) {
            return "securitybreach";
        }
        return super.doExecute();
    }

    public Collection getRoleActorTypes(ProjectRole projectRole, String type, int length) {
        ProjectRoleActors projectRoleActors = this.projectRoleService.getProjectRoleActors(projectRole, this.getProject(), (ErrorCollection)this);
        if (projectRoleActors == null) {
            return Collections.EMPTY_LIST;
        }
        Set roleActorsByType = projectRoleActors.getRoleActorsByType(type);
        if (length == -1 || roleActorsByType.size() <= length) {
            return projectRoleActors.getRoleActorsByType(type);
        }
        return new ArrayList(projectRoleActors.getRoleActorsByType(type)).subList(0, length);
    }

    public Project getProject() {
        return this.projectManager.getProjectObj(this.getProjectId());
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Collection getRoleActors(ProjectRole projectRole) {
        ProjectRoleActors projectRoleActors = this.projectRoleService.getProjectRoleActors(projectRole, this.getProject(), (ErrorCollection)this);
        if (projectRoleActors == null) {
            return Collections.emptyList();
        }
        Set roleActors = projectRoleActors.getRoleActors();
        TreeSet<RoleActor> sortedRoleActors = new TreeSet<RoleActor>(RoleActorComparator.COMPARATOR);
        if (roleActors != null) {
            sortedRoleActors.addAll(roleActors);
        }
        return sortedRoleActors;
    }
}

