/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class FilterViewTabs {
    public static final Tab POPULAR = new Tab("popular");
    public static final Tab SEARCH = new Tab("search");
    public static final Tab FAVOURITES = new Tab("favourites");
    public static final Tab MY = new Tab("my");
    public static final Tab PROJECT = new Tab("projects");
    public final Map<String, Tab> tabs;
    public final Tab defaultTab;
    public Tab firstTab = null;

    public FilterViewTabs(List<Tab> tabs, Tab defaultTab) {
        this.firstTab = (Tab)Iterables.get(tabs, (int)0);
        this.tabs = Maps.uniqueIndex(tabs, (Function)new Function<Tab, String>(){

            public String apply(@Nullable Tab aTab) {
                if (aTab != null) {
                    return aTab.getName();
                }
                return "";
            }
        });
        this.defaultTab = defaultTab;
    }

    public boolean isValid(String tabName) {
        return this.getTab(tabName) != null;
    }

    public boolean isFirst(String tabName) {
        return this.firstTab.nameEquals(tabName);
    }

    public Tab getTab(String tabName) {
        if (tabName == null) {
            return null;
        }
        return this.tabs.get(tabName.toLowerCase());
    }

    public Tab getTabSafely(String tabName) {
        Tab returnTab = this.getTab(tabName);
        return returnTab == null ? this.defaultTab : returnTab;
    }

    public static final class Tab {
        private final String name;

        public Tab(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean nameEquals(String name) {
            return this.name.equalsIgnoreCase(name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tab tab = (Tab)o;
            return this.name.equals(tab.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "Tab [" + this.getName() + "]";
        }
    }
}

