/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.subscription.FilterSubscription;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.filter.AbstractFilterAction;
import com.atlassian.jira.web.action.filter.FilterOperationsAction;
import com.atlassian.mail.server.MailServerManager;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ManageSubscriptions
extends AbstractFilterAction
implements FilterOperationsAction {
    private final FilterSubscriptionService filterSubscriptionService;
    private final MailServerManager mailServerManager;
    private final UserManager userManager;
    private Collection<FilterSubscription> subscriptions;

    public ManageSubscriptions(IssueSearcherManager issueSearcherManager, FilterSubscriptionService filterSubscriptionService, MailServerManager mailServerManager, SearchService searchService, UserManager userManager) {
        super(issueSearcherManager, searchService);
        this.filterSubscriptionService = filterSubscriptionService;
        this.mailServerManager = mailServerManager;
        this.userManager = userManager;
    }

    public String doDefault() throws Exception {
        return this.getFilterId() == null ? this.getRedirect("ManageFilters.jspa") : super.doDefault();
    }

    public int getSubscriptionCount() {
        return this.getSubscriptions().size();
    }

    public Collection getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = this.filterSubscriptionService.getVisibleFilterSubscriptions(this.getLoggedInUser(), this.getFilter());
        }
        return this.subscriptions;
    }

    public boolean isMailConfigured() {
        List smtpServers = this.mailServerManager.getSmtpMailServers();
        return !smtpServers.isEmpty();
    }

    public String doView() {
        return "success";
    }

    public String getSubscriber(FilterSubscription subscription) {
        String userKey = subscription.getUserKey();
        ApplicationUser user = this.userManager.getUserByKey(userKey);
        if (user == null) {
            return userKey;
        }
        return user.getDisplayName();
    }

    public boolean loggedInUserIsOwner(FilterSubscription subscription) {
        ApplicationUser loggedInUser = this.getLoggedInUser();
        return loggedInUser != null && loggedInUser.getKey().equals(subscription.getUserKey());
    }

    public String getCronTooltip(FilterSubscription sub) {
        String cronExpression = this.filterSubscriptionService.getCronExpression(this.getJiraServiceContext(), sub);
        return cronExpression == null ? "" : this.getText("cron.editor.cronstring") + " '" + cronExpression + "'";
    }

    public String getPrettySchedule(FilterSubscription sub) {
        String cronExpression = this.filterSubscriptionService.getCronExpression(this.getJiraServiceContext(), sub);
        return cronExpression == null ? "" : this.filterSubscriptionService.getPrettySchedule(this.getJiraServiceContext(), cronExpression);
    }

    public String getLastSent(FilterSubscription sub) {
        Date ts = sub.getLastRunTime();
        return ts == null ? "Never" : this.getOutlookDate().formatDMYHMS(ts);
    }

    public String getNextSend(FilterSubscription sub) {
        Date nextSendTime = this.filterSubscriptionService.getNextSendTime(sub);
        return nextSendTime == null ? "" : this.getDateTimeFormatter().format(nextSendTime);
    }

    public boolean isGroupValid(FilterSubscription sub) {
        String groupName = sub.getGroupName();
        return TextUtils.stringSet((String)groupName) && this.userManager.getGroup(groupName) != null;
    }
}

