/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.issue.transport.impl.FieldValuesHolderImpl;
import com.atlassian.jira.web.action.filter.AbstractFilterAction;
import com.atlassian.jira.web.action.filter.FilterOperationsAction;
import com.atlassian.jira.web.action.util.DiffViewRenderer;
import com.atlassian.query.order.SearchSort;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SaveFilter
extends AbstractFilterAction
implements FilterOperationsAction {
    private final SearchRequestService searchRequestService;
    private final SearchService searchService;
    private final DiffViewRenderer diffViewRenderer;
    private SearchRequest dbSearchRequest;
    private SearchContext dbSearchContext;
    private FieldValuesHolder dbFieldValuesHolder;

    public SaveFilter(IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, SearchService searchService, DiffViewRenderer diffViewRenderer) {
        super(issueSearcherManager, searchService);
        this.searchRequestService = searchRequestService;
        this.searchService = searchService;
        this.diffViewRenderer = diffViewRenderer;
    }

    public SaveFilter(SearchRequestService searchRequestService, SearchService searchService, DiffViewRenderer diffViewRenderer) {
        this((IssueSearcherManager)ComponentAccessor.getComponentOfType(IssueSearcherManager.class), searchRequestService, searchService, diffViewRenderer);
    }

    public String doDefault() throws Exception {
        if (!this.validateSearchRequest()) {
            return "error";
        }
        this.updateDbRequestState();
        return "input";
    }

    protected String doExecute() throws Exception {
        if (!this.validateSearchRequest()) {
            return "error";
        }
        SearchRequest newRequest = this.searchRequestService.updateSearchParameters(this.getJiraServiceContext(), this.getSearchRequest());
        if (newRequest == null || this.hasAnyErrors()) {
            return "error";
        }
        this.setSearchRequest(newRequest);
        return this.getRedirect(this.getHttpRequest().getContextPath() + "/issues/?filter=" + this.getFilterId());
    }

    public List<SearchSort> getSearchSorts(SearchRequest searchRequest) {
        if (searchRequest != null && searchRequest.getQuery().getOrderByClause() != null) {
            return searchRequest.getQuery().getOrderByClause().getSearchSorts();
        }
        return Collections.emptyList();
    }

    private void updateDbRequestState() {
        if (this.getSearchRequest() == null || this.getFilterId() == null) {
            this.dbSearchRequest = new SearchRequest();
            this.dbSearchRequest.setOwner(this.getLoggedInUser());
        } else {
            this.dbSearchRequest = this.getFilter();
        }
        this.dbFieldValuesHolder = new FieldValuesHolderImpl();
        this.dbSearchContext = this.searchService.getSearchContext(this.getLoggedInUser(), this.dbSearchRequest.getQuery());
        Collection searchers = this.issueSearcherManager.getAllSearchers();
        for (IssueSearcher searcher : searchers) {
            searcher.getSearchInputTransformer().populateFromQuery(this.getLoggedInUser(), this.dbFieldValuesHolder, this.dbSearchRequest.getQuery(), this.dbSearchContext);
        }
    }

    private boolean validateSearchRequest() {
        if (this.getSearchRequest() == null) {
            this.addErrorMessage(this.getText("admin.errors.filters.no.search.request"));
            return false;
        }
        return this.searchRequestService.validateUpdateSearchParameters(this.getJiraServiceContext(), this.getSearchRequest());
    }

    @Override
    public Long getFilterId() {
        SearchRequest searchRequest = this.getSearchRequest();
        return searchRequest != null ? searchRequest.getId() : null;
    }
}

