/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.JiraProductInformation;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.setup.IndexLanguageToLocaleMapper;
import com.atlassian.license.SIDManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSetupAction
extends JiraWebActionSupport {
    protected static final String SETUP_ALREADY = "setupalready";
    private static final String SETUP_SESSION_ID_KEY = "setup-session-id";
    public static final String DEFAULT_GROUP_ADMINS = "jira-administrators";
    protected final FileFactory fileFactory;
    protected final JiraProperties jiraProperties;
    private final JiraProductInformation jiraProductInformation;

    public AbstractSetupAction(FileFactory fileFactory, JiraProperties jiraProperties, JiraProductInformation jiraProductInformation) {
        this.fileFactory = fileFactory;
        this.jiraProperties = jiraProperties;
        this.jiraProductInformation = jiraProductInformation;
    }

    public boolean setupAlready() {
        return this.getApplicationProperties().getString("jira.setup") != null;
    }

    protected void validateFormPathParam(String formElement, String blankErrorMessage, String nonUniqueErrorMessage, String myPath, Collection<String> otherPaths) {
        if (!TextUtils.stringSet((String)myPath)) {
            this.addError(formElement, this.getText(blankErrorMessage));
        } else {
            for (String otherPath : otherPaths) {
                if (!myPath.equals(otherPath)) continue;
                this.addError(formElement, this.getText(nonUniqueErrorMessage));
            }
            this.validateSetupPath(myPath, formElement);
        }
    }

    protected void validateSetupPath(String paramPath, String formElement) {
        File attachmentDir = this.fileFactory.getFile(paramPath);
        if (!attachmentDir.isAbsolute()) {
            this.addError(formElement, this.getText("setup.error.filepath.notabsolute"));
        } else if (!attachmentDir.exists()) {
            try {
                if (!attachmentDir.mkdirs()) {
                    this.addError(formElement, this.getText("setup.error.filepath.notexist"));
                }
            }
            catch (Exception e) {
                this.addError(formElement, this.getText("setup.error.filepath.notexist"));
            }
        } else if (!attachmentDir.isDirectory()) {
            this.addError(formElement, this.getText("setup.error.filepath.notdir"));
        } else if (!attachmentDir.canWrite()) {
            this.addError(formElement, this.getText("setup.error.filepath.notwriteable"));
        }
    }

    protected String getCurrentTrackerStepId() {
        return "";
    }

    @ActionViewData
    public List<Map<String, Object>> getTrackerSteps() {
        ImmutableList.Builder defaultsBuilder = ImmutableList.builder();
        defaultsBuilder.add((Object)ImmutableMap.of((Object)"href", (Object)"#", (Object)"id", (Object)"setup-tracker-database", (Object)"text", (Object)"Database setup"));
        defaultsBuilder.add((Object)ImmutableMap.of((Object)"href", (Object)"#", (Object)"id", (Object)"setup-tracker-properties-and-licensing", (Object)"text", (Object)"Properties & Licensing"));
        defaultsBuilder.add((Object)ImmutableMap.of((Object)"href", (Object)"#", (Object)"id", (Object)"setup-tracker-admin-account", (Object)"text", (Object)"Admin account"));
        defaultsBuilder.add((Object)ImmutableMap.of((Object)"href", (Object)"#", (Object)"id", (Object)"setup-tracker-email", (Object)"text", (Object)"Email setup"));
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map item : defaultsBuilder.build()) {
            builder.add((Object)MapBuilder.newBuilder().addAll(item).add((Object)"isCurrent", (Object)(item.get("id").equals(this.getCurrentTrackerStepId()) ? 1 : 0)).toMap());
        }
        return builder.build();
    }

    @ActionViewData
    public String getModifierKey() {
        return BrowserUtils.getModifierKey();
    }

    public String getSetupSessionId() {
        String sessionId = (String)this.getHttpSession().getAttribute(SETUP_SESSION_ID_KEY);
        if (sessionId == null) {
            sessionId = UUID.randomUUID().toString();
            this.getHttpSession().setAttribute(SETUP_SESSION_ID_KEY, (Object)sessionId);
        }
        return sessionId;
    }

    @ActionViewData
    public String getLicenseProductKey() {
        return this.jiraProductInformation.getLicenseProductKey();
    }

    public String getServerId() {
        String serverId = this.getApplicationProperties().getString("jira.sid.key");
        if (!StringUtils.isBlank((String)serverId)) {
            return serverId;
        }
        String generatedServerId = ((SIDManager)ComponentAccessor.getComponentOfType(SIDManager.class)).generateSID();
        this.getApplicationProperties().setString("jira.sid.key", generatedServerId);
        return generatedServerId;
    }

    public boolean isLocaleValid(String locale) {
        LocaleManager localeManager = (LocaleManager)ComponentAccessor.getComponentOfType(LocaleManager.class);
        Set installedLocales = localeManager.getInstalledLocales();
        return installedLocales.contains(localeManager.getLocale(locale));
    }

    public void setJiraLocale(String locale) {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        if (this.isLocaleValid(locale)) {
            applicationProperties.setString("jira.i18n.default.locale", locale);
        }
    }

    public void setIndexingLanguageForDefaultServerLocale() {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        IndexLanguageToLocaleMapper languageToLocaleMapper = (IndexLanguageToLocaleMapper)ComponentAccessor.getComponent(IndexLanguageToLocaleMapper.class);
        applicationProperties.setString("jira.i18n.language.index", languageToLocaleMapper.getLanguageForLocale(this.getLocale().toString()));
    }

    public String isInstantSetup() {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        return String.valueOf(applicationProperties.getOption("jira.setup.is.instant"));
    }

    public String getAnalyticsIframeUrl() {
        String defaultUrl = this.jiraProperties.isDevMode() ? "https://qa-wac.internal.atlassian.com/pingback" : "https://www.atlassian.com/pingback";
        return this.jiraProperties.getProperty("jira.setup.analytics.iframe.url", defaultUrl);
    }
}

