/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.exception.runtime.CommunicationException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.jira.bc.security.login.LoginResult;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.user.UserPasswordActionHelper;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ChangePassword
extends JiraWebActionSupport {
    private String current;
    private String password;
    private String confirm;
    private String username;
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final PasswordPolicyManager passwordPolicyManager;
    private final List<WebErrorMessage> passwordErrors = new ArrayList<WebErrorMessage>();
    private final LoginService loginService;

    public ChangePassword(UserUtil userUtil, UserManager userManager, PasswordPolicyManager passwordPolicyManager, LoginService loginService) {
        this.userUtil = userUtil;
        this.userManager = userManager;
        this.passwordPolicyManager = passwordPolicyManager;
        this.loginService = loginService;
    }

    public String doDefault() throws Exception {
        ApplicationUser current = this.getLoggedInUser();
        if (current == null || !current.getUsername().equals(this.username)) {
            return "error";
        }
        if (!this.userManager.userCanUpdateOwnDetails(current)) {
            this.addErrorMessage(this.getText("editprofile.not.allowed"));
            return "error";
        }
        return super.doDefault();
    }

    protected void doValidation() {
        ApplicationUser user = (ApplicationUser)Assertions.notNull((String)"user", (Object)this.getLoggedInUser());
        if (user == null) {
            this.addErrorMessage(this.getText("changepassword.could.not.find.user"));
            return;
        }
        if (!this.userManager.userCanUpdateOwnDetails(user)) {
            this.addErrorMessage(this.getText("editprofile.not.allowed"));
            return;
        }
        try {
            LoginResult loginResult = this.loginService.authenticate(user, this.current);
            switch (loginResult.getReason()) {
                case OK: {
                    break;
                }
                case AUTHENTICATION_DENIED: {
                    this.addErrorMessage(this.getText("changepassword.elevated.authorisation.required"));
                    break;
                }
                case AUTHORISATION_FAILED: {
                    this.addErrorMessage(this.getText("changepassword.could.not.find.user"));
                    break;
                }
                case AUTHENTICATED_FAILED: {
                    this.addError("current", this.getText("changepassword.current.password.incorrect"));
                }
            }
        }
        catch (CommunicationException communicationException) {
            this.log.debug((Object)"Error communicating with remote user directory.", (Throwable)communicationException);
            this.addErrorMessage(this.getText("login.error.communication"));
        }
        catch (OperationFailedException operationFailedException) {
            this.log.debug((Object)"Internal error occurred while authorising current user in the user directory.", (Throwable)operationFailedException);
            this.addError("current", this.getText("login.error.misc"));
        }
        catch (Exception e) {
            this.log.debug((Object)"Exception occurred while trying to authorise current user.", (Throwable)e);
            this.addErrorMessage(this.getText("changepassword.could.not.find.user"));
        }
        if (!TextUtils.stringSet((String)this.password)) {
            this.addError("password", this.getText("changepassword.new.password.required"));
        } else if (!this.password.equals(this.confirm)) {
            this.addError("confirm", this.getText("changepassword.new.password.confirmation.does.not.match"));
        } else {
            Collection<WebErrorMessage> messages = this.passwordPolicyManager.checkPolicy(user, this.current, this.password);
            if (!messages.isEmpty()) {
                this.addError("password", this.getText("changepassword.new.password.rejected"));
                for (WebErrorMessage message : messages) {
                    this.passwordErrors.add(message);
                }
            }
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ApplicationUser currentUser = this.getLoggedInUser();
        if (currentUser == null || !currentUser.getName().equals(this.username)) {
            return "error";
        }
        new UserPasswordActionHelper(this, this.userUtil).setPassword(currentUser, this.password);
        if (this.invalidInput()) {
            return "error";
        }
        return this.returnComplete();
    }

    public boolean canUpdateUserPassword() {
        return this.userManager.canUpdateUserPassword(this.getLoggedInUser());
    }

    public String doSuccess() {
        return "success";
    }

    public void setCurrent(String current) {
        this.current = current;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<WebErrorMessage> getPasswordErrors() {
        return this.passwordErrors;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean getElevatedSecurityCheckRequired() {
        return this.loginService.getLoginInfo(this.username).isElevatedSecurityCheckRequired();
    }
}

