/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.user.UserPasswordActionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import webwork.action.ResultException;

public class ResetPassword
extends JiraWebActionSupport {
    private final UserUtil userUtil;
    private final PasswordPolicyManager passwordPolicyManager;
    private String token;
    private String os_username;
    private String password;
    private String confirm;
    private ApplicationUser userInPlay;
    private boolean userInvalid;
    private boolean tokenTimedOut;
    private boolean tokenInvalid;
    private final List<WebErrorMessage> passwordErrors = new ArrayList<WebErrorMessage>();

    public ResetPassword(UserUtil userUtil, PasswordPolicyManager passwordPolicyManager) {
        this.userUtil = userUtil;
        this.passwordPolicyManager = passwordPolicyManager;
    }

    public String doDefault() {
        this.validateUserAndToken();
        if (this.hasAnyErrors()) {
            return "error";
        }
        return "input";
    }

    protected void validate() throws ResultException {
        this.validateUserAndToken();
        if (!(this.userInvalid || this.tokenInvalid || this.tokenTimedOut)) {
            this.validateNewPasswords();
        }
    }

    protected String doExecute() {
        if (this.userInvalid || this.tokenInvalid || this.tokenTimedOut || this.invalidInput()) {
            return "error";
        }
        new UserPasswordActionHelper(this, this.userUtil).setPassword(this.userInPlay, this.password);
        if (this.invalidInput()) {
            return "error";
        }
        return "success";
    }

    private void validateUserAndToken() {
        boolean isValid = true;
        this.userInPlay = this.userUtil.getUser(this.os_username);
        if (this.userInPlay == null) {
            isValid = false;
            this.userInvalid = true;
        } else {
            UserUtil.PasswordResetTokenValidation validation = this.userUtil.validatePasswordResetToken(this.userInPlay, this.token);
            if (validation.getStatus() == UserUtil.PasswordResetTokenValidation.Status.EXPIRED) {
                isValid = false;
                this.tokenTimedOut = true;
            } else if (validation.getStatus() == UserUtil.PasswordResetTokenValidation.Status.UNEQUAL) {
                isValid = false;
                this.tokenInvalid = true;
            }
        }
        if (!isValid) {
            this.addErrorMessage(this.getText("resetpassword.error.invalid.user.or.token"));
        }
    }

    private void validateNewPasswords() {
        if (StringUtils.isBlank((String)this.password) || StringUtils.isBlank((String)this.confirm)) {
            this.addErrorMessage(this.getText("resetpassword.error.password.blank"));
        } else if (!this.nvl(this.password, "").equals(this.confirm)) {
            this.addErrorMessage(this.getText("resetpassword.error.password.mustmatch"));
        } else {
            Collection<WebErrorMessage> messages = this.passwordPolicyManager.checkPolicy(this.userUtil.getUserByName(this.os_username), null, this.password);
            if (!messages.isEmpty()) {
                this.addError("password", this.getText("changepassword.new.password.rejected"));
                for (WebErrorMessage message : messages) {
                    this.passwordErrors.add(message);
                }
            }
        }
    }

    private String nvl(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getOs_username() {
        return this.os_username;
    }

    public void setOs_username(String os_username) {
        this.os_username = os_username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<WebErrorMessage> getPasswordErrors() {
        return this.passwordErrors;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public boolean isTokenTimedOut() {
        return this.tokenTimedOut;
    }

    public boolean isTokenInvalid() {
        return this.tokenInvalid;
    }

    public boolean isUserInvalid() {
        return this.userInvalid;
    }
}

