/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.query.Query;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import webwork.action.ServletActionContext;

public class ViewUserHover
extends JiraWebActionSupport {
    private static final ImmutableList<Integer> WEEKEND = ImmutableList.of((Object)6, (Object)7);
    private String username;
    private ApplicationUser user;
    private URI avatarUrl;
    private final UserManager userManager;
    private final EmailFormatter emailFormatter;
    private final SearchService searchService;
    private final PermissionManager permissionManager;
    private final SimpleLinkManager simpleLinkManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final TimeZoneService timeZoneService;
    @ClusterSafe(value="WebWork actions are ephemeral")
    private final LazyReference<SimpleDateFormat> hourOfDayFormatter = new HourOfDayFormatterRef();
    private final AvatarService avatarService;

    public ViewUserHover(UserManager userManager, EmailFormatter emailFormatter, SearchService searchService, PermissionManager permissionManager, SimpleLinkManager simpleLinkManager, DateTimeFormatterFactory dateTimeFormatterFactory, TimeZoneService timeZoneService, AvatarService avatarService) {
        this.userManager = userManager;
        this.emailFormatter = emailFormatter;
        this.searchService = searchService;
        this.permissionManager = permissionManager;
        this.simpleLinkManager = simpleLinkManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.timeZoneService = timeZoneService;
        this.avatarService = avatarService;
    }

    public String doDefault() throws Exception {
        if (this.getLoggedInUser() == null) {
            return "login";
        }
        this.avatarUrl = this.avatarService.getAvatarURL(this.getLoggedInUser(), this.user, Avatar.Size.LARGE);
        return "success";
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.user = this.userManager.getUserByName(username);
    }

    public String getAvatarUrl() {
        return this.avatarUrl.toString();
    }

    public String getAssigneeQuery() {
        Query query = JqlQueryBuilder.newClauseBuilder().assignee().eq(this.username).and().resolution().isEmpty().buildQuery();
        return this.searchService.getIssueSearchPath(this.getLoggedInUser(), SearchService.IssueSearchParameters.builder().query(query).build());
    }

    public String getFormattedEmail() {
        if (this.user != null) {
            return this.emailFormatter.formatEmailAsLink(this.user.getEmailAddress(), this.getLoggedInUser());
        }
        return "";
    }

    public String getTime() {
        return this.dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.TIME).withZone(this.getUserTimeZone()).format(new Date());
    }

    public String getDayOfWeek() {
        SimpleDateFormat df = new SimpleDateFormat("EEEE", this.getLocale());
        df.setTimeZone(this.getUserTimeZone());
        return df.format(new Date());
    }

    public String getHourOfDay() {
        return ((SimpleDateFormat)this.hourOfDayFormatter.get()).format(new Date());
    }

    @Nullable
    public Boolean getIsWeekend() {
        return WEEKEND.contains((Object)new DateTime((Object)new Date(), DateTimeZone.forTimeZone((TimeZone)this.getUserTimeZone())).getDayOfWeek()) ? Boolean.TRUE : null;
    }

    public SimpleLink getFirstHoverLink() {
        List<SimpleLink> simpleLinkList = this.getHoverLinks();
        if (simpleLinkList.isEmpty()) {
            return null;
        }
        return simpleLinkList.get(0);
    }

    public List<SimpleLink> getRemainingLinks() {
        List<SimpleLink> simpleLinkList = this.getHoverLinks();
        if (simpleLinkList.isEmpty()) {
            return Collections.emptyList();
        }
        return simpleLinkList.subList(1, simpleLinkList.size());
    }

    public List<SimpleLink> getHoverLinks() {
        if (this.user != null) {
            ApplicationUser remoteUser = this.getLoggedInUser();
            HttpServletRequest servletRequest = ServletActionContext.getRequest();
            Map params = MapBuilder.newBuilder().add((Object)"profileUser", (Object)this.urlEncode(this.getUsername())).add((Object)"jqlquery", (Object)this.getAssigneeQuery()).toMap();
            JiraHelper helper = new JiraHelper(servletRequest, null, params);
            return this.simpleLinkManager.getLinksForSection("system.user.hover.links", remoteUser, helper);
        }
        return Collections.emptyList();
    }

    public boolean isShowUploadAvatarLink() {
        ApplicationUser currentUser = this.getLoggedInUser();
        boolean isUserViewingOwnAvatar = this.user != null && this.user.equals((Object)currentUser);
        return isUserViewingOwnAvatar && this.avatarService.canSetCustomUserAvatar(currentUser, this.user) && !this.avatarService.hasCustomUserAvatar(currentUser, this.user);
    }

    public String getTimeZoneCity() {
        return this.getUserTimeZoneInfo().getCity();
    }

    TimeZone getUserTimeZone() {
        return this.getUserTimeZoneInfo().toTimeZone();
    }

    private TimeZoneInfo getUserTimeZoneInfo() {
        return this.timeZoneService.getUserTimeZoneInfo((JiraServiceContext)new JiraServiceContextImpl(this.user));
    }

    private class HourOfDayFormatterRef
    extends LazyReference<SimpleDateFormat> {
        private HourOfDayFormatterRef() {
        }

        protected SimpleDateFormat create() throws Exception {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH");
            dateFormat.setTimeZone(ViewUserHover.this.getUserTimeZone());
            return dateFormat;
        }
    }
}

