/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperationImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpSession;

public class ConvertIssueBean
implements OperationContext,
Serializable {
    private static final long serialVersionUID = 2944128397663718521L;
    private static final String SESSION_KEY = "com.atlassian.jira.web.bean.ConvertIssueBean";
    private static final AtomicLong versionCounter = new AtomicLong(0L);
    protected String issueId;
    protected Map<String, Object> fieldValuesHolder = new HashMap<String, Object>();
    protected String issueType;
    protected String targetStatusId;
    protected String version;
    protected String sessionKey;
    protected int currentStep = 0;

    public static ConvertIssueBean getBean(HttpSession session, String issueId) {
        return ConvertIssueBean.getBeanFromSession(ConvertIssueBean.class, SESSION_KEY, session, issueId);
    }

    public static ConvertIssueBean getBeanFromSession(Class beanClass, String sessionKey, HttpSession session, String issueId) {
        HashMap<String, ConvertIssueBean> beanMap;
        Object foo = session.getAttribute(sessionKey);
        if (foo == null) {
            beanMap = new HashMap<String, ConvertIssueBean>(1);
            session.setAttribute(sessionKey, beanMap);
        } else {
            beanMap = (HashMap<String, ConvertIssueBean>)foo;
        }
        ConvertIssueBean bean = (ConvertIssueBean)beanMap.get(issueId);
        if (bean == null) {
            try {
                bean = (ConvertIssueBean)beanClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            bean.setIssueId(issueId);
            bean.setSessionKey(sessionKey);
            beanMap.put(issueId, bean);
        }
        return bean;
    }

    public void clearBean() {
        this.fieldValuesHolder.clear();
        this.issueType = null;
        this.targetStatusId = null;
        this.version = null;
    }

    public void clearSession(HttpSession session) {
        Object foo = session.getAttribute(this.sessionKey);
        if (foo != null) {
            Map beanMap = (Map)foo;
            beanMap.remove(this.issueId);
            if (beanMap.isEmpty()) {
                session.removeAttribute(this.sessionKey);
            }
        }
    }

    public String toString() {
        String extraFields;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" [");
        if (this.issueId != null) {
            sb.append(" issueId:");
            sb.append(this.issueId);
        }
        if (this.issueType != null) {
            sb.append(" issueType:");
            sb.append(this.issueType);
        }
        if (this.targetStatusId != null) {
            sb.append(" targetStatusId:");
            sb.append(this.targetStatusId);
        }
        if (this.version != null) {
            sb.append(" GUID:");
            sb.append(this.version);
        }
        if ((extraFields = this.extraFieldsToString()) != null) {
            sb.append(extraFields);
        }
        sb.append(" ]");
        return sb.toString();
    }

    public String extraFieldsToString() {
        return null;
    }

    public Map<String, Object> getFieldValuesHolder() {
        return this.fieldValuesHolder;
    }

    public IssueOperation getIssueOperation() {
        return new IssueOperationImpl("Convert Issue Operation", "Convert issue Operation");
    }

    public String getIssueId() {
        return this.issueId;
    }

    public void setIssueId(String issueId) {
        this.issueId = issueId;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    public String getTargetStatusId() {
        return this.targetStatusId;
    }

    public void setTargetStatusId(String targetStatusId) {
        this.targetStatusId = targetStatusId;
    }

    public String getVersion() {
        return this.version;
    }

    public void generateNextVersion() {
        this.version = String.valueOf(versionCounter.getAndIncrement());
    }

    public void setCurrentStep(int step) {
        this.currentStep = step;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }
}

