/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.visibility.Visibilities;
import com.atlassian.jira.bc.issue.visibility.Visibility;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.OperationContextImpl;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.WorkflowIssueOperationImpl;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowFunctionUtils;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowProgressAware;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class WorkflowTransitionUtilImpl
implements WorkflowProgressAware,
WorkflowTransitionUtil {
    private final ErrorCollection errorCollection = new SimpleErrorCollection();
    private final JiraAuthenticationContext authenticationContext;
    private final WorkflowManager workflowManager;
    private final PermissionManager permissionManager;
    private MutableIssue issue;
    private Project project;
    private int actionId;
    private ActionDescriptor actionDescriptor;
    private Map<String, Object> params = Maps.newHashMap();
    @Nullable
    private ApplicationUser remoteUser;
    private FieldScreenRenderer fieldScreenRenderer;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final CommentService commentService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final Map additionalInputs = Maps.newHashMap();

    public WorkflowTransitionUtilImpl(JiraAuthenticationContext authenticationContext, WorkflowManager workflowManager, PermissionManager permissionManager, FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService, I18nHelper.BeanFactory i18nFactory) {
        this.authenticationContext = authenticationContext;
        this.workflowManager = workflowManager;
        this.permissionManager = permissionManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.commentService = commentService;
        this.i18nFactory = i18nFactory;
        this.remoteUser = authenticationContext.getUser();
    }

    public MutableIssue getIssue() {
        return this.issue;
    }

    public void setIssue(MutableIssue issue) {
        this.issue = issue;
    }

    private String getComment() {
        return (String)this.params.get("comment");
    }

    private String getCommentLevel() {
        return (String)this.params.get("commentLevel");
    }

    private String getCommentRoleLevel() {
        return (String)this.params.get("roleLevel");
    }

    public Project getProject() {
        return this.getProjectObject();
    }

    public Project getProjectObject() {
        if (this.project == null) {
            this.project = this.issue.getProjectObject();
        }
        return this.project;
    }

    public ApplicationUser getRemoteUser() {
        return this.getRemoteApplicationUser();
    }

    public ApplicationUser getRemoteApplicationUser() {
        return this.remoteUser;
    }

    public int getAction() {
        return this.actionId;
    }

    public void setAction(int action) {
        this.actionId = action;
    }

    public ActionDescriptor getActionDescriptor() {
        if (this.actionDescriptor == null) {
            this.actionDescriptor = this.retrieveActionDescriptorWithPermissionCheck();
        }
        return this.actionDescriptor;
    }

    private ActionDescriptor retrieveActionDescriptorWithPermissionCheck() {
        try {
            if (!this.hasTransitionPermission()) {
                throw new IllegalArgumentException(String.format("User %s doesn't have permission transition for issue %s.", this.getUserKey(), this.getIssue().getKey()));
            }
            return this.retrieveActionDescriptor();
        }
        catch (WorkflowException e) {
            throw new IllegalArgumentException("Cannot find workflow transition with id '" + this.actionId + "'.", e);
        }
    }

    private ActionDescriptor retrieveActionDescriptor() {
        ActionDescriptor retrievedActionDescriptor = this.impersonateUser(new Supplier<ActionDescriptor>(){

            public ActionDescriptor get() {
                return WorkflowTransitionUtilImpl.this.workflowManager.getWorkflow((Issue)WorkflowTransitionUtilImpl.this.getIssue()).getDescriptor().getAction(WorkflowTransitionUtilImpl.this.actionId);
            }
        });
        if (retrievedActionDescriptor == null) {
            throw new IllegalArgumentException("No workflow action with id '" + this.actionId + "' available for issue " + this.getIssue().getKey());
        }
        return retrievedActionDescriptor;
    }

    public void addErrorMessage(String error) {
        this.errorCollection.addErrorMessage(error);
    }

    public void addError(String name, String error) {
        this.errorCollection.addError(name, error);
    }

    public Map getAdditionalInputs() {
        HashMap<String, String> map = new HashMap<String, String>(this.additionalInputs.size() + 3);
        map.putAll(this.additionalInputs);
        if (this.fieldUpdated("comment")) {
            map.put("comment", this.getComment());
            map.put("commentLevel", this.getCommentLevel());
            map.put("roleLevel", this.getCommentRoleLevel());
        }
        WorkflowFunctionUtils.populateParamsWithUser(map, (String)this.getUserKey());
        return map;
    }

    public void addAdditionalInput(Object key, Object value) {
        this.additionalInputs.put(key, value);
    }

    public String getUsername() {
        return this.getUsername(this.getRemoteApplicationUser());
    }

    @Nullable
    private String getUsername(@Nullable ApplicationUser user) {
        return user != null ? user.getUsername() : null;
    }

    public void setUsername(String username) {
        this.remoteUser = ComponentAccessor.getUserManager().getUserByName(username);
    }

    public String getUserKey() {
        return ApplicationUsers.getKeyFor(this.getRemoteApplicationUser());
    }

    public void setUserkey(String userkey) {
        this.remoteUser = ApplicationUsers.byKey(userkey);
    }

    public ErrorCollection validate() {
        return this.impersonateUser(new Supplier<ErrorCollection>(){

            public ErrorCollection get() {
                WorkflowTransitionUtilImpl.this.validateComment();
                WorkflowTransitionUtilImpl.this.validateTransitionPermission();
                if (WorkflowTransitionUtilImpl.this.errorCollection.hasAnyErrors()) {
                    return WorkflowTransitionUtilImpl.this.errorCollection;
                }
                WorkflowTransitionUtilImpl.this.validateFieldsParams();
                return WorkflowTransitionUtilImpl.this.errorCollection;
            }
        });
    }

    private void validateFieldsParams() {
        for (FieldScreenRenderTab fieldScreenRenderTab : this.getFieldScreenRenderer().getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                if (!fieldScreenRenderLayoutItem.isShow((Issue)this.getIssue())) continue;
                OrderableField orderableField = fieldScreenRenderLayoutItem.getOrderableField();
                boolean isResolutionField = "resolution".equals(orderableField.getId());
                FieldScreenRenderLayoutItem itemWithHack = isResolutionField ? this.makeRequired(fieldScreenRenderLayoutItem) : fieldScreenRenderLayoutItem;
                orderableField.validateParams(this.getOperationContext(), this.errorCollection, this.getI18n(), (Issue)this.getIssue(), itemWithHack);
            }
        }
    }

    private FieldScreenRenderLayoutItem makeRequired(FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        return new FieldScreenRenderLayoutItemImpl(fieldScreenRenderLayoutItem.getFieldScreenLayoutItem(), fieldScreenRenderLayoutItem.getFieldLayoutItem()){

            @Override
            public boolean isRequired() {
                return true;
            }
        };
    }

    private I18nHelper getI18n() {
        return this.i18nFactory.getInstance(this.getRemoteApplicationUser());
    }

    public FieldScreenRenderer getFieldScreenRenderer() {
        if (this.fieldScreenRenderer == null) {
            this.fieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer((Issue)this.getIssue(), this.getActionDescriptor());
        }
        return this.fieldScreenRenderer;
    }

    private void validateTransitionPermission() {
        if (!this.hasTransitionPermission()) {
            this.addErrorMessage(this.getI18nMessageWithUser("admin.errors.user.does.not.have.transition.permission"));
        }
    }

    private void validateComment() {
        if (this.fieldUpdated("comment")) {
            ApplicationUser remoteApplicationUser = this.getRemoteApplicationUser();
            if (this.permissionManager.hasPermission(ProjectPermissions.ADD_COMMENTS, (Issue)this.getIssue(), remoteApplicationUser)) {
                Visibility visibility = Visibilities.fromGroupAndStrRoleId((String)this.getCommentLevel(), (String)this.getCommentRoleLevel());
                this.commentService.isValidCommentVisibility(remoteApplicationUser, (Issue)this.getIssue(), visibility, this.errorCollection);
                if (!this.fieldUpdated("commentLevel") && !this.fieldUpdated("roleLevel")) {
                    this.setCommentLevel(null);
                }
            } else {
                this.errorCollection.addErrorMessage(this.getI18nMessageWithUser("admin.errors.user.does.not.have.permission"));
            }
        }
    }

    private String getI18nMessageWithUser(String i18nKey) {
        ApplicationUser remoteApplicationUser = this.getRemoteApplicationUser();
        I18nHelper i18n = this.getI18n();
        String username = remoteApplicationUser != null ? i18n.getText("admin.errors.user", "'" + remoteApplicationUser.getName() + "'") : i18n.getText("admin.errors.anonymous.user");
        return i18n.getText(i18nKey, username);
    }

    private void setCommentLevel(String commentLevel) {
        this.params.put("commentLevel", commentLevel);
    }

    public ErrorCollection progress() {
        if (this.hasScreen()) {
            for (FieldScreenRenderTab fieldScreenRenderTab : this.getFieldScreenRenderer().getFieldScreenRenderTabs()) {
                for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                    if (!fieldScreenRenderLayoutItem.isShow((Issue)this.getIssue())) continue;
                    fieldScreenRenderLayoutItem.getOrderableField().updateIssue(fieldScreenRenderLayoutItem.getFieldLayoutItem(), this.getIssue(), this.params);
                }
            }
        }
        this.workflowManager.doWorkflowAction((WorkflowProgressAware)this);
        return this.errorCollection;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public boolean hasScreen() {
        return StringUtils.isNotBlank((String)this.getActionDescriptor().getView());
    }

    private boolean fieldUpdated(String fieldId) {
        return this.params.containsKey(fieldId);
    }

    private OperationContext getOperationContext() {
        return new OperationContextImpl((IssueOperation)new WorkflowIssueOperationImpl(this.getActionDescriptor()), this.params);
    }

    private boolean hasTransitionPermission() {
        return this.permissionManager.hasPermission(ProjectPermissions.TRANSITION_ISSUES, (Issue)this.getIssue(), this.getRemoteApplicationUser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T impersonateUser(Supplier<T> supplier) {
        ApplicationUser oldUser = this.authenticationContext.getUser();
        this.authenticationContext.setLoggedInUser(this.getRemoteApplicationUser());
        try {
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            this.authenticationContext.setLoggedInUser(oldUser);
        }
    }
}

