/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class EnterpriseWorkflowTaskContext
implements TaskContext {
    private static final long serialVersionUID = -8380874131082626949L;
    private final Long triggerProjectId;
    private final Long schemeId;
    private final boolean draftMigration;
    private final List<Long> projectIds;
    private boolean safeToDelete;

    public EnterpriseWorkflowTaskContext(Project triggerProject) {
        this(triggerProject, null, true);
    }

    public EnterpriseWorkflowTaskContext(Project triggerProject, Long schemeId, boolean draftMigration) {
        this(triggerProject, Arrays.asList(triggerProject), schemeId, draftMigration);
        Assertions.notNull((String)"triggerProject", (Object)triggerProject);
    }

    public EnterpriseWorkflowTaskContext(Project triggerProject, List<Project> projects, Long schemeId, boolean draftMigration) {
        Assertions.notEmpty((String)"projects", projects);
        this.schemeId = schemeId;
        this.triggerProjectId = triggerProject != null ? triggerProject.getId() : null;
        this.projectIds = this.getProjectIds(projects);
        this.draftMigration = draftMigration;
    }

    private ImmutableList<Long> getProjectIds(List<Project> projects) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(projects, (Function)new Function<Project, Long>(){

            public Long apply(Project project) {
                return project.getId();
            }
        }));
    }

    @Override
    public String buildProgressURL(Long taskId) {
        String url = "/secure/project/SelectProjectWorkflowSchemeStep3.jspa?taskId=" + taskId + "&draftMigration=" + this.isDraftMigration() + "&projectIdsParameter=" + this.getProjectIdString();
        if (this.triggerProjectId != null) {
            url = url + "&projectId=" + this.triggerProjectId;
        }
        if (this.getSchemeId() != null) {
            url = url + "&schemeId=" + this.getSchemeId();
        }
        return url;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public boolean isDraftMigration() {
        return this.draftMigration;
    }

    private String getProjectIdString() {
        return StringUtils.join(this.projectIds, (String)",");
    }

    public boolean isSafeToDelete() {
        return this.safeToDelete;
    }

    public void markSafeToDelete() {
        this.safeToDelete = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnterpriseWorkflowTaskContext that = (EnterpriseWorkflowTaskContext)o;
        return CollectionUtils.isNotEmpty((Collection)CollectionUtils.intersection(this.projectIds, that.projectIds));
    }

    public int hashCode() {
        return 0;
    }

    @VisibleForTesting
    public Long getTriggerProjectId() {
        return this.triggerProjectId;
    }
}

