/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server.managers;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.core.user.preferences.DefaultPreferences;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.mail.MailConstants;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerConfigurationHandler;
import com.atlassian.mail.server.PopMailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.impl.PopMailServerImpl;
import com.atlassian.mail.server.managers.AbstractMailServerManager;
import com.atlassian.mail.server.managers.EventAwareSMTPMailServer;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

public class OFBizMailServerManager
extends AbstractMailServerManager {
    private static final String CACHE_NAME = OFBizMailServerManager.class.getName() + ".server";
    private static final String ALL_CACHE_NAME = OFBizMailServerManager.class.getName() + ".allServers";
    private DefaultPreferences defaultPreferences = new DefaultPreferences();
    private LazyReference<CacheHolder> cacheSupplier = new LazyReference<CacheHolder>(){

        protected CacheHolder create() throws Exception {
            return new CacheHolder();
        }
    };

    public MailServer getMailServer(Long id) throws MailException {
        try {
            GenericValue gv = ComponentAccessor.getOfBizDelegator().findByPrimaryKey("MailServer", UtilMisc.toMap((String)"id", (Object)id));
            if (gv == null) {
                return null;
            }
            return this.constructMailServer(gv);
        }
        catch (DataAccessException e) {
            throw new MailException((Throwable)e);
        }
    }

    public MailServer getMailServer(String name) throws MailException {
        return ((CacheHolder)this.cacheSupplier.get()).getMailServer(name);
    }

    private List<MailServer> getAllServers() {
        return ((CacheHolder)this.cacheSupplier.get()).getAll();
    }

    public List<String> getServerNames() throws MailException {
        return Lists.newArrayList((Iterable)Iterables.transform(this.getAllServers(), (Function)new Function<MailServer, String>(){

            public String apply(MailServer from) {
                return from.getName();
            }
        }));
    }

    public List<SMTPMailServer> getSmtpMailServers() {
        return this.getMailServersByType(SMTPMailServer.class);
    }

    public List<PopMailServer> getPopMailServers() {
        return this.getMailServersByType(PopMailServer.class);
    }

    public Long create(MailServer mailServer) throws MailException {
        try {
            GenericValue storedMailServer = EntityUtils.createValue("MailServer", this.getMapFromColumns(mailServer));
            Long l = storedMailServer.getLong("id");
            return l;
        }
        catch (DataAccessException e) {
            throw new MailException((Throwable)e);
        }
        finally {
            ((CacheHolder)this.cacheSupplier.get()).remove(mailServer.getName());
        }
    }

    public void update(MailServer mailServer) throws MailException {
        block6: {
            try {
                GenericValue storedMailServer = this.getMailServerGV(mailServer.getId());
                if (storedMailServer != null) {
                    storedMailServer.setFields(this.getMapFromColumns(mailServer));
                    ComponentAccessor.getOfBizDelegator().store(storedMailServer);
                    break block6;
                }
                throw new MailException("Server '" + mailServer.getId() + "' not found.");
            }
            catch (DataAccessException e) {
                throw new MailException((Throwable)e);
            }
            finally {
                ((CacheHolder)this.cacheSupplier.get()).remove(mailServer.getName());
            }
        }
    }

    public void delete(Long mailServerId) throws MailException {
        try {
            GenericValue storedMailServer = this.getMailServerGV(mailServerId);
            if (storedMailServer != null) {
                ComponentAccessor.getOfBizDelegator().removeValue(storedMailServer);
            }
        }
        catch (DataAccessException e) {
            throw new MailException((Throwable)e);
        }
        finally {
            ((CacheHolder)this.cacheSupplier.get()).reset();
        }
    }

    @Nullable
    public SMTPMailServer getDefaultSMTPMailServer() {
        try {
            SMTPMailServer smtps = (SMTPMailServer)this.getMailServer(this.defaultPreferences.getString("DefaultSmtpServer"));
            if (smtps != null) {
                return smtps;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<SMTPMailServer> smtpMailServers = this.getSmtpMailServers();
        if (smtpMailServers == null || smtpMailServers.size() == 0) {
            return null;
        }
        return smtpMailServers.get(0);
    }

    @Nullable
    public PopMailServer getDefaultPopMailServer() {
        try {
            PopMailServer pops = (PopMailServer)this.getMailServer(this.defaultPreferences.getString("DefaultPopServer"));
            if (pops != null) {
                return pops;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<PopMailServer> popMailServers = this.getPopMailServers();
        if (popMailServers == null || popMailServers.size() == 0) {
            return null;
        }
        return popMailServers.get(0);
    }

    protected <T extends MailServer> List<T> getMailServersByType(Class<T> serverType) {
        return Lists.newArrayList((Iterable)Iterables.filter(this.getAllServers(), serverType));
    }

    protected GenericValue getMailServerGV(Long id) throws MailException {
        try {
            return ComponentAccessor.getOfBizDelegator().findByPrimaryKey("MailServer", UtilMisc.toMap((String)"id", (Object)id));
        }
        catch (DataAccessException e) {
            throw new MailException((Throwable)e);
        }
    }

    protected MailServer constructMailServer(GenericValue gv) {
        MailServer mailServer = this.constructMailServerImpl(gv);
        MailServerConfigurationHandler mailServerConfigurationHandler = this.getMailServerConfigurationHandler();
        if (mailServerConfigurationHandler != null) {
            mailServerConfigurationHandler.configureMailServer(mailServer);
        }
        return mailServer;
    }

    private MailServer constructMailServerImpl(GenericValue gv) {
        long timeout;
        String protocol;
        String serverType = gv.getString("type");
        String port = gv.getString("smtpPort");
        if (port == null) {
            port = this.getDefaultPort(serverType);
        }
        MailProtocol mailProtocol = (protocol = gv.getString("protocol")) != null ? MailProtocol.getMailProtocol((String)protocol) : this.getDefaultProtocol(serverType);
        long l = timeout = gv.getLong("timeout") == null ? 10000L : gv.getLong("timeout");
        if (SERVER_TYPES[0].equals(serverType)) {
            return new PopMailServerImpl(gv.getLong("id"), gv.getString("name"), gv.getString("description"), mailProtocol, gv.getString("servername"), port, gv.getString("username"), gv.getString("password"), timeout, gv.getString("socksHost"), gv.getString("socksPort"));
        }
        if (SERVER_TYPES[1].equals(serverType)) {
            boolean isTlsRequired = Boolean.valueOf(gv.getString("istlsrequired"));
            if (TextUtils.stringSet((String)gv.getString("servername"))) {
                return new EventAwareSMTPMailServer(gv.getLong("id"), gv.getString("name"), gv.getString("description"), gv.getString("from"), gv.getString("prefix"), false, mailProtocol, gv.getString("servername"), port, isTlsRequired, gv.getString("username"), gv.getString("password"), timeout, gv.getString("socksHost"), gv.getString("socksPort"));
            }
            return new EventAwareSMTPMailServer(gv.getLong("id"), gv.getString("name"), gv.getString("description"), gv.getString("from"), gv.getString("prefix"), true, mailProtocol, gv.getString("jndilocation"), port, isTlsRequired, gv.getString("username"), gv.getString("password"), timeout, gv.getString("socksHost"), gv.getString("socksPort"));
        }
        return null;
    }

    private MailProtocol getDefaultProtocol(String serverType) {
        return SERVER_TYPES[0].equals(serverType) ? MailConstants.DEFAULT_POP_PROTOCOL : MailConstants.DEFAULT_SMTP_PROTOCOL;
    }

    private String getDefaultPort(String serverType) {
        return SERVER_TYPES[0].equals(serverType) ? "110" : "25";
    }

    protected Map<String, Object> getMapFromColumns(MailServer mailServer) throws MailException {
        HashMap columns = Maps.newHashMap();
        columns.put("name", mailServer.getName());
        columns.put("description", mailServer.getDescription());
        columns.put("username", mailServer.getUsername());
        columns.put("password", mailServer.getPassword());
        columns.put("type", mailServer.getType());
        columns.put("servername", mailServer.getHostname());
        columns.put("smtpPort", mailServer.getPort());
        columns.put("protocol", mailServer.getMailProtocol().getProtocol());
        columns.put("timeout", mailServer.getTimeout());
        columns.put("socksHost", mailServer.getSocksHost());
        columns.put("socksPort", mailServer.getSocksPort());
        if (!SERVER_TYPES[0].equals(mailServer.getType())) {
            if (SERVER_TYPES[1].equals(mailServer.getType())) {
                SMTPMailServer smtp = (SMTPMailServer)mailServer;
                columns.put("from", smtp.getDefaultFrom());
                columns.put("prefix", smtp.getPrefix());
                columns.put("istlsrequired", Boolean.toString(smtp.isTlsRequired()));
                if (smtp.isSessionServer()) {
                    columns.put("jndilocation", smtp.getJndiLocation());
                } else {
                    columns.put("servername", smtp.getHostname());
                }
            } else {
                throw new MailException("The Type of Mail Server is not recognised");
            }
        }
        return columns;
    }

    protected class CacheHolder {
        private final ComponentReference<CacheManager> cacheManagerRef = ComponentAccessor.getComponentReference(CacheManager.class);
        private final ComponentReference<EventPublisher> eventPublisherRef = ComponentAccessor.getComponentReference(EventPublisher.class);
        private final Cache<Option<String>, Option<MailServer>> mailServerCache;
        private final CachedReference<List<MailServer>> allMailServerCache;

        public CacheHolder() {
            CacheSettings cacheSettings = new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
            this.mailServerCache = ((CacheManager)this.cacheManagerRef.get()).getCache(CACHE_NAME, (CacheLoader)new MailServerCacheLoader(), cacheSettings);
            CacheSettings allCacheSettings = new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
            this.allMailServerCache = ((CacheManager)this.cacheManagerRef.get()).getCachedReference(ALL_CACHE_NAME, (Supplier)new AllMailServersSupplier(), allCacheSettings);
            ((EventPublisher)this.eventPublisherRef.get()).register((Object)this);
        }

        @EventListener
        public void clearCache(ClearCacheEvent event) {
            this.reset();
        }

        public MailServer getMailServer(String name) {
            return (MailServer)((Option)this.mailServerCache.get((Object)Option.option((Object)name))).getOrNull();
        }

        @Nonnull
        public List<MailServer> getAll() {
            return (List)this.allMailServerCache.get();
        }

        public void remove(String name) {
            this.allMailServerCache.reset();
            this.mailServerCache.removeAll();
        }

        public void reset() {
            this.allMailServerCache.reset();
            this.mailServerCache.removeAll();
        }
    }

    private class MailServerCacheLoader
    implements CacheLoader<Option<String>, Option<MailServer>> {
        private MailServerCacheLoader() {
        }

        @Nonnull
        public Option<MailServer> load(@Nonnull Option<String> name) {
            try {
                GenericValue gv = EntityUtil.getOnly((List)ComponentAccessor.getOfBizDelegator().findByAnd("MailServer", UtilMisc.toMap((String)"name", (Object)name.getOrNull())));
                if (gv == null) {
                    return Option.none();
                }
                return Option.some((Object)OFBizMailServerManager.this.constructMailServer(gv));
            }
            catch (DataAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class AllMailServersSupplier
    implements Supplier<List<MailServer>> {
        private AllMailServersSupplier() {
        }

        public List<MailServer> get() {
            try {
                List mailServerGVs = ComponentAccessor.getOfBizDelegator().findAll("MailServer", UtilMisc.toList((Object)"id asc"));
                return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)mailServerGVs, (Function)new Function<GenericValue, MailServer>(){

                    public MailServer apply(GenericValue from) {
                        return OFBizMailServerManager.this.constructMailServer(from);
                    }
                }));
            }
            catch (DataAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

