/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.ofbiz.util;

import com.atlassian.core.ofbiz.CoreFactory;
import java.sql.Connection;
import org.ofbiz.core.entity.GenericTransactionException;
import org.ofbiz.core.entity.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreTransactionUtil {
    private static final Logger log = LoggerFactory.getLogger(CoreTransactionUtil.class);
    static boolean useTransactions = true;
    static int isolationLevel = 2;

    @Deprecated
    public static boolean begin() throws GenericTransactionException {
        if (useTransactions) {
            return TransactionUtil.beginLocalTransaction((String)CoreFactory.getGenericDelegator().getGroupHelperName("default"), (int)isolationLevel);
        }
        return true;
    }

    @Deprecated
    public static void commit(boolean began) throws GenericTransactionException {
        if (useTransactions) {
            TransactionUtil.commitLocalTransaction((boolean)began);
        }
    }

    @Deprecated
    public static void rollback(boolean began) throws GenericTransactionException {
        if (useTransactions) {
            if (log.isDebugEnabled()) {
                log.debug("Transaction rollback requested", (Throwable)new RuntimeException());
            }
            TransactionUtil.rollbackLocalTransaction((boolean)began);
        }
    }

    @Deprecated
    public static void setRollbackOnly(boolean began) throws GenericTransactionException {
        if (useTransactions) {
            if (log.isDebugEnabled()) {
                log.debug("Transaction rollback requested", (Throwable)new RuntimeException());
            }
            TransactionUtil.rollbackRequiredLocalTransaction((boolean)began);
        }
    }

    public static void setUseTransactions(boolean useTransactions) {
        CoreTransactionUtil.useTransactions = useTransactions;
    }

    public static int getIsolationLevel() {
        return isolationLevel;
    }

    public static void setIsolationLevel(int isolationLevel) {
        CoreTransactionUtil.isolationLevel = isolationLevel;
    }

    public static Connection getConnection() {
        if (useTransactions) {
            return TransactionUtil.getLocalTransactionConnection();
        }
        return null;
    }

    public static boolean inTransaction() {
        return useTransactions && TransactionUtil.getLocalTransactionConnection() != null;
    }
}

