/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.ofbiz.util.database.mssql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSSQLIndexUtil {
    private static final Logger log = LoggerFactory.getLogger(MSSQLIndexUtil.class);
    private static final String MSSQL_METADATA_PRODUCT_NAME = "Microsoft SQL Server";
    private static final int INDEX_SIZE_BEFORE_MSSQL_2016 = 900;
    private static final int INDEX_SIZE_SINCE_MSSQL_2016 = 1700;
    private static final String COUNT_INCLUDED_COLUMNS_IN_INDEX_SQL = "SELECT COUNT(is_included_column) as count FROM sys.indexes as indexes\nJOIN sys.index_columns as columns\nON indexes.object_id = columns.object_id AND indexes.index_id = columns.index_id\nJOIN sys.tables as tables\nON columns.object_id = tables.object_id\nWHERE indexes.name = ? AND tables.name = ? AND is_included_column = 1";

    private MSSQLIndexUtil() {
    }

    public static int getUnclusteredMaximumKeySizeForMajorVersion(int majorVersion) {
        if (majorVersion < 11) {
            log.warn(String.format("Database Version %d is not in acceptable range. Some functionalities may not work properly", majorVersion));
            return 900;
        }
        if (majorVersion < 13) {
            return 900;
        }
        return 1700;
    }

    public static boolean isSqlServer(Connection conn) throws SQLException {
        return conn.getMetaData().getDatabaseProductName().equals(MSSQL_METADATA_PRODUCT_NAME);
    }

    public static int getDbMajorVersion(Connection conn) throws SQLException {
        return conn.getMetaData().getDatabaseMajorVersion();
    }

    public static boolean isMSSQLAndMajorVersion(Connection connection, int expectedMajorVersion) throws SQLException {
        return MSSQLIndexUtil.isMSSQLAndMajorVersion(connection, majorVersion -> majorVersion == expectedMajorVersion);
    }

    public static boolean isMSSQLAndMajorVersion(Connection connection, Predicate<Integer> majorVersionPredicate) throws SQLException {
        return MSSQLIndexUtil.isSqlServer(connection) && majorVersionPredicate.test(MSSQLIndexUtil.getDbMajorVersion(connection));
    }

    public static boolean indexHasIncludedColumns(Connection connection, String tableName, String indexName) throws SQLException {
        return MSSQLIndexUtil.getCountFromIndexTableQuery(connection, COUNT_INCLUDED_COLUMNS_IN_INDEX_SQL, tableName, indexName) > 0;
    }

    public static int getCountFromIndexTableQuery(Connection connection, String sql, String tableName, String indexName) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, indexName);
            statement.setString(2, tableName);
            ResultSet resultSet = statement.executeQuery();
            resultSet.next();
            int n = resultSet.getInt("count");
            return n;
        }
    }
}

