/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

abstract class AbstractApplicationRole
implements ApplicationRole {
    private final ImmutableSet<Group> groups;
    private final ImmutableSet<Group> defaultGroups;
    private final int numberOfSeats;
    private final boolean selectedByDefault;

    AbstractApplicationRole(Iterable<Group> groups, Iterable<Group> defaultGroups, int numberOfSeats, boolean selectedByDefault) {
        Assertions.containsNoNulls((String)"groups", groups);
        Assertions.containsNoNulls((String)"defaultGroups", defaultGroups);
        if (numberOfSeats < 0 && numberOfSeats != -1) {
            throw new IllegalArgumentException("Illegal numberOfSeats: " + numberOfSeats);
        }
        this.defaultGroups = ImmutableSet.copyOf(defaultGroups);
        this.groups = ImmutableSet.copyOf(groups);
        this.numberOfSeats = numberOfSeats;
        this.selectedByDefault = selectedByDefault;
        if (!this.groups.containsAll(this.defaultGroups)) {
            throw new IllegalArgumentException(String.format("defaultGroups '%s' not a subset of '%s'.", this.defaultGroups, this.groups));
        }
    }

    @Nonnull
    public final Set<Group> getGroups() {
        return this.groups;
    }

    @Nonnull
    public final Set<Group> getDefaultGroups() {
        return this.defaultGroups;
    }

    public int getNumberOfSeats() {
        return this.numberOfSeats;
    }

    public boolean isSelectedByDefault() {
        return this.selectedByDefault;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ApplicationRole) {
            ApplicationRole that = (ApplicationRole)o;
            return this.getKey().equals((Object)that.getKey());
        }
        return false;
    }

    public final int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("key", (Object)this.getKey()).append("groups", this.groups).append("defaultGroups", this.defaultGroups).append("numberOfSeats", this.numberOfSeats).append("selectedByDefault", this.selectedByDefault).append("defined", this.isDefined()).toString();
    }
}

