/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.PlatformApplication;
import com.atlassian.application.host.AbstractApplicationManager;
import com.atlassian.application.host.ApplicationAccessFactory;
import com.atlassian.application.host.ApplicationConfigurationManager;
import com.atlassian.application.host.i18n.I18nResolver;
import com.atlassian.application.host.license.LicenseLocator;
import com.atlassian.application.host.plugin.PluginApplicationMetaDataManager;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.DefaultApplicationRoleDefinitions;
import com.atlassian.jira.application.JiraI18nResolver;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import io.atlassian.fugue.Option;
import java.net.URI;
import org.joda.time.DateTime;

public class JiraApplicationManager
extends AbstractApplicationManager {
    private final PlatformApplication platformApplication;
    static final String CREATE_CORE_USER_URL = "/secure/admin/user/AddUser!default.jspa?selectedApplications=%s";

    public JiraApplicationManager(PluginApplicationMetaDataManager pluginApplications, BuildUtilsInfo info, JiraAuthenticationContext ctx, LicenseLocator locator, ApplicationAccessFactory accessFactory, ApplicationConfigurationManager appConfigManager) {
        super(pluginApplications, (I18nResolver)new JiraI18nResolver(ctx), locator, accessFactory, appConfigManager);
        this.platformApplication = new JiraCoreApplication(ctx, locator, accessFactory, info, appConfigManager);
    }

    public PlatformApplication getPlatform() {
        return this.platformApplication;
    }

    private static class JiraCoreApplication
    implements PlatformApplication {
        private final JiraAuthenticationContext ctx;
        private final LicenseLocator locator;
        private final ApplicationAccessFactory accessFactory;
        private final BuildUtilsInfo info;
        private final ApplicationConfigurationManager appConfigManager;

        private JiraCoreApplication(JiraAuthenticationContext ctx, LicenseLocator locator, ApplicationAccessFactory accessFactory, BuildUtilsInfo info, ApplicationConfigurationManager appConfigManager) {
            this.info = (BuildUtilsInfo)Assertions.notNull((String)"info", (Object)info);
            this.ctx = (JiraAuthenticationContext)Assertions.notNull((String)"ctx", (Object)ctx);
            this.locator = (LicenseLocator)Assertions.notNull((String)"locator", (Object)locator);
            this.accessFactory = (ApplicationAccessFactory)Assertions.notNull((String)"accessFactory", (Object)accessFactory);
            this.appConfigManager = (ApplicationConfigurationManager)Assertions.notNull((String)"appConfigManager", (Object)appConfigManager);
        }

        public ApplicationKey getKey() {
            return DefaultApplicationRoleDefinitions.CoreRoleDefinition.INSTANCE.key();
        }

        public String getName() {
            return DefaultApplicationRoleDefinitions.CoreRoleDefinition.INSTANCE.name();
        }

        public String getDescription() {
            return this.ctx.getI18nHelper().getText("jira.core.description");
        }

        public String getVersion() {
            return this.info.getVersion();
        }

        public String getUserCountDescription(Option<Integer> count) {
            return this.ctx.getI18nHelper().getText("jira.core.user.count", count.getOrElse((Object)-1));
        }

        public Option<URI> getConfigurationURI() {
            return Option.none();
        }

        public Option<URI> getPostInstallURI() {
            return Option.some((Object)URI.create(String.format(JiraApplicationManager.CREATE_CORE_USER_URL, ApplicationKeys.CORE.value())));
        }

        public Option<URI> getPostUpdateURI() {
            return Option.none();
        }

        public Option<URI> getProductHelpServerSpaceURI() {
            return Option.some((Object)URI.create("jcore-docs-" + this.info.getDocVersion()));
        }

        public Option<URI> getProductHelpCloudSpaceURI() {
            return Option.some((Object)URI.create("JIRACORECLOUD"));
        }

        public String getDefaultGroup() {
            return "jira-core-users";
        }

        public void clearConfiguration() {
            this.appConfigManager.clearConfiguration(this.getKey());
        }

        public DateTime buildDate() {
            return new DateTime((Object)this.info.getCurrentBuildDate());
        }

        public Option<SingleProductLicenseDetailsView> getLicense() {
            return (Option)this.locator.apply((Object)this.getKey());
        }

        public ApplicationAccess getAccess() {
            return this.accessFactory.access(this.getKey(), this.buildDate());
        }
    }
}

