/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application.install;

import com.atlassian.jira.application.install.ApplicationInstallationEnvironment;
import com.atlassian.jira.application.install.ApplicationSource;
import com.atlassian.jira.application.install.BundlesVersionDiscovery;
import com.atlassian.jira.application.install.PluginBundleInstaller;
import com.atlassian.jira.application.install.ReversibleFileOperations;
import com.atlassian.jira.application.install.WhatWasInstalled;
import com.atlassian.jira.plugin.PluginPath;
import com.atlassian.jira.plugin.freeze.FreezeFileManager;
import com.atlassian.jira.plugin.freeze.FreezeFileManagerFactory;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Nonnull
public class ApplicationInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationInstaller.class);
    private final ApplicationInstallationEnvironment environment;
    private final BundlesVersionDiscovery versionDiscovery;
    private final WhatWasInstalled whatWasInstalled;
    private final PluginPath pluginPath;
    private FreezeFileManagerFactory freezeFileManagerFactory;

    public ApplicationInstaller(ApplicationInstallationEnvironment environment, BundlesVersionDiscovery versionDiscovery, WhatWasInstalled whatWasInstalled, PluginPath pluginPath, FreezeFileManagerFactory freezeFileManagerFactory) {
        this.environment = environment;
        this.versionDiscovery = versionDiscovery;
        this.whatWasInstalled = whatWasInstalled;
        this.pluginPath = pluginPath;
        this.freezeFileManagerFactory = freezeFileManagerFactory;
    }

    public void installApplications() {
        File[] applicationsSources = this.environment.getApplicationsSource().listFiles(File::isDirectory);
        if (null == applicationsSources || 0 == applicationsSources.length) {
            LOGGER.trace("No applications source directories - skipping.");
            return;
        }
        Arrays.stream(applicationsSources).map(ApplicationSource::readFromDir).filter(Objects::nonNull).forEach(this::installApplicationFiles);
    }

    private void installApplicationFiles(ApplicationSource applicationSource) {
        PluginBundleInstaller pluginBundleInstaller = this.createPluginBundleInstaller();
        try {
            if (this.whatWasInstalled.wasApplicationSourceInstalled(applicationSource)) {
                LOGGER.trace("Application was already installed: " + applicationSource.getApplicationSourceName());
                return;
            }
            try (ReversibleFileOperations reversibleFileOperations = new ReversibleFileOperations();){
                for (File sourceFile : applicationSource.getApplicationBundles()) {
                    pluginBundleInstaller.updatePlugin(sourceFile, reversibleFileOperations);
                }
                this.whatWasInstalled.storeInstalledApplicationSource(applicationSource, reversibleFileOperations);
                reversibleFileOperations.commit();
            }
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private PluginBundleInstaller createPluginBundleInstaller() {
        FreezeFileManager freezeFileManager = this.freezeFileManagerFactory.create(this.pluginPath.getPluginsFreezeFile(), this.pluginPath.getInstalledPluginsDirectory());
        return new PluginBundleInstaller(this.environment.getApplicationsDestination(), this.versionDiscovery, freezeFileManager);
    }
}

