/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application.install;

import java.io.File;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;

class ApplicationSource {
    private final String applicationSourceName;
    private final File[] applicationBundles;

    ApplicationSource(String applicationSourceName, File[] applicationBundles) {
        this.applicationSourceName = applicationSourceName;
        this.applicationBundles = applicationBundles;
        Arrays.sort(this.applicationBundles, (o1, o2) -> o1.getName().compareTo(o2.getName()));
    }

    public String getApplicationSourceName() {
        return this.applicationSourceName;
    }

    public File[] getApplicationBundles() {
        return this.applicationBundles;
    }

    @Nullable
    static ApplicationSource readFromDir(File dir) {
        Object[] applicationFiles = dir.listFiles(ApplicationSource::jarsOnly);
        return ArrayUtils.isNotEmpty((Object[])applicationFiles) ? new ApplicationSource(dir.getName(), (File[])applicationFiles) : null;
    }

    static boolean jarsOnly(File file) {
        return file.isFile() && file.getName().endsWith(".jar");
    }
}

