/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.JiraUpgradeEventHandler;
import com.atlassian.jira.cluster.zdu.JiraUpgradeApprovedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeCancelledEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeFailedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeFinishedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeStartedEvent;
import com.atlassian.jira.cluster.zdu.NodeBuildInfo;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class JiraUpgradeEventHandlerImpl
implements JiraUpgradeEventHandler {
    private final I18nHelper.BeanFactory i18nHelper;

    public JiraUpgradeEventHandlerImpl(I18nHelper.BeanFactory i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    @Override
    public RecordRequest onStartedEvent(JiraUpgradeStartedEvent event) {
        List<ChangedValue> changedValues = this.getVersionInfoValues(null, event.getNodeBuildInfo());
        return new RecordRequest(AuditingCategory.SYSTEM, "jira.auditing.upgrade.started").withDescription(this.getI18n().getText("jira.auditing.upgrade.started.description")).withChangedValues(changedValues);
    }

    @Override
    public RecordRequest onCancelledEvent(JiraUpgradeCancelledEvent event) {
        List<ChangedValue> changedValues = this.getVersionInfoValues(null, event.getNodeBuildInfo());
        return new RecordRequest(AuditingCategory.SYSTEM, "jira.auditing.upgrade.cancelled").withDescription(this.getI18n().getText("jira.auditing.upgrade.cancelled.description")).withChangedValues(changedValues);
    }

    @Override
    public RecordRequest onApprovedEvent(JiraUpgradeApprovedEvent event) {
        List<ChangedValue> changedValues = this.getVersionInfoValues(event.getFromVersion(), event.getToVersion());
        return new RecordRequest(AuditingCategory.SYSTEM, "jira.auditing.upgrade.approved").withDescription(this.getI18n().getText("jira.auditing.upgrade.approved.description")).withChangedValues(changedValues);
    }

    @Override
    public RecordRequest onFinishedEvent(JiraUpgradeFinishedEvent event) {
        List<ChangedValue> changedValues = this.getVersionInfoValues(event.getFromVersion(), event.getToVersion());
        return new RecordRequest(AuditingCategory.SYSTEM, "jira.auditing.upgrade.finished").withDescription(this.getI18n().getText("jira.auditing.upgrade.finished.description")).withChangedValues(changedValues);
    }

    @Override
    public RecordRequest onFailedEvent(JiraUpgradeFailedEvent event) {
        List<ChangedValue> versions = this.getVersionInfoValues(event.getFromVersion(), event.getToVersion());
        ImmutableList<ChangedValue> errors = new ChangedValuesBuilder().add("jira.auditing.upgrade.failed.errors", "", event.getErrors().stream().collect(Collectors.joining("\n")).toString()).build();
        Iterable changedValues = Iterables.concat(versions, errors);
        return new RecordRequest(AuditingCategory.SYSTEM, "jira.auditing.upgrade.failed").withDescription(this.getI18n().getText("jira.auditing.upgrade.failed.description")).withChangedValues(changedValues);
    }

    private List<ChangedValue> getVersionInfoValues(@Nullable NodeBuildInfo previous, NodeBuildInfo current) {
        return new ChangedValuesBuilder().addIfDifferent("admin.systeminfo.version", previous != null ? previous.getVersion() : null, current.getVersion()).addIfDifferent("admin.systeminfo.build.number", previous != null ? String.valueOf(previous.getBuildNumber()) : null, String.valueOf(current.getBuildNumber())).build();
    }

    private I18nHelper getI18n() {
        return this.i18nHelper.getInstance(Locale.ENGLISH);
    }
}

