/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.crowd.event.user.AutoUserUpdatedEvent;
import com.atlassian.crowd.event.user.ResetPasswordEvent;
import com.atlassian.crowd.event.user.UserAttributeDeletedEvent;
import com.atlassian.crowd.event.user.UserAttributeStoredEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserCredentialUpdatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.event.user.UserEmailChangedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.crowd.model.user.User;
import com.atlassian.jira.auditing.AffectedUser;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.HandlerUtils;
import com.atlassian.jira.auditing.handlers.UserEventHandler;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationFinishedEvent;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationStartedEvent;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class UserEventHandlerImpl
implements UserEventHandler {
    private final I18nHelper.BeanFactory i18nBeanFactory;

    public UserEventHandlerImpl(I18nHelper.BeanFactory i18nBeanFactory) {
        this.i18nBeanFactory = i18nBeanFactory;
    }

    @Override
    public Option<RecordRequest> handleUserUpdatedEvent(UserUpdatedEvent event) {
        if (event instanceof AutoUserUpdatedEvent) {
            return this.onAutoUserUpdatedEvent((AutoUserUpdatedEvent)event);
        }
        if (event instanceof ResetPasswordEvent) {
            return Option.option((Object)this.onResetPasswordEvent((ResetPasswordEvent)event));
        }
        if (event instanceof UserRenamedEvent) {
            return Option.option((Object)this.onUserRenamedEvent((UserRenamedEvent)event));
        }
        if (event instanceof UserAttributeStoredEvent || event instanceof UserAttributeDeletedEvent) {
            return Option.none();
        }
        if (event instanceof UserEditedEvent) {
            return this.onUserEditedEvent((UserEditedEvent)event);
        }
        if (event instanceof UserEmailChangedEvent) {
            return Option.none();
        }
        throw new RuntimeException("Unsupported event: " + event.getClass().getName());
    }

    private Option<RecordRequest> onAutoUserUpdatedEvent(AutoUserUpdatedEvent event) {
        return this.userUpdated(event.getOriginalUser(), event.getUser());
    }

    private Option<RecordRequest> onUserEditedEvent(UserEditedEvent event) {
        return this.userUpdated(event.getOriginalUser(), event.getUser());
    }

    private Option<RecordRequest> userUpdated(User originalUser, final User user) {
        return HandlerUtils.requestIfThereAreAnyValues(this.buildChangedValues(originalUser, user), new Function<List<ChangedValue>, RecordRequest>(){

            public RecordRequest apply(List<ChangedValue> changedValues) {
                return new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.updated").withChangedValues(changedValues).forObject((AssociatedItem)new AffectedUser(user));
            }
        });
    }

    private RecordRequest onResetPasswordEvent(ResetPasswordEvent event) {
        return new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.password.reset").forObject((AssociatedItem)new AffectedUser(event.getUser()));
    }

    private RecordRequest onUserRenamedEvent(UserRenamedEvent event) {
        return new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.renamed").withChangedValues(new ChangedValuesBuilder().addIfDifferent("common.words.username", event.getOldUsername(), event.getUser().getName()).build()).forObject((AssociatedItem)new AffectedUser(event.getUser()));
    }

    private List<ChangedValue> buildChangedValues(User originalUser, User currentUser) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.addIfDifferent("common.words.username", originalUser == null ? null : originalUser.getName(), currentUser.getName()).addIfDifferent("common.words.fullname", originalUser == null ? null : originalUser.getDisplayName(), currentUser.getDisplayName()).addIfDifferent("common.words.email", originalUser == null ? null : originalUser.getEmailAddress(), currentUser.getEmailAddress()).addIfDifferent("admin.common.phrases.active.inactive", originalUser == null ? null : UserEventHandlerImpl.stringBooleanToActiveInactive(originalUser.isActive()), UserEventHandlerImpl.stringBooleanToActiveInactive(currentUser.isActive()));
        return changedValues.build();
    }

    public static String stringBooleanToActiveInactive(Boolean tBoolean) {
        if (tBoolean == null) {
            return "";
        }
        return tBoolean.equals(Boolean.TRUE) ? "Active" : "Inactive";
    }

    @Override
    public RecordRequest handleUserCreatedEvent(UserCreatedEvent event) {
        User user = event.getUser();
        return new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.created").withChangedValues(this.buildChangedValues(user)).forObject((AssociatedItem)new AffectedUser(user));
    }

    @Override
    public Option<RecordRequest> handleUserDeletedEvent(UserDeletedEvent event) {
        return Option.none();
    }

    @Override
    public RecordRequest handleUserCredentialUpdatedEvent(UserCredentialUpdatedEvent event) {
        String userKey = ComponentAccessor.getUserKeyService().getKeyForUsername(event.getUsername());
        return new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.password.changed").forObject((AssociatedItem)new AffectedUser(event.getUsername(), userKey, event.getDirectory()));
    }

    private List<ChangedValue> buildChangedValues(User currentUser) {
        return this.buildChangedValues(null, currentUser);
    }

    @Override
    public RecordRequest handleUserAnonymizationStartedEvent(UserAnonymizationStartedEvent event) {
        RecordRequest recordRequest = new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.anonymization.started").withDescription(this.getI18n().getText("jira.auditing.user.anonymization.started.description", event.getUserName(), event.getUserKey())).forObject((AssociatedItem)new AffectedUser(event.getUserName(), event.getUserKey(), null));
        return recordRequest;
    }

    @Override
    public RecordRequest handleUserAnonymizationFinishedEvent(UserAnonymizationFinishedEvent event) {
        RecordRequest recordRequest = new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.anonymized").withDescription(this.getI18n().getText("jira.auditing.user.anonymized.description", event.getUserName(), event.getOldUserName(), event.getUserKey(), event.getOldUserKey())).forObject((AssociatedItem)new AffectedUser(event.getUserName(), event.getUserKey(), null));
        if (!Objects.equals(event.getUserName(), event.getOldUserName())) {
            recordRequest.withAssociatedItems(new AssociatedItem[]{new AffectedUser(event.getOldUserName(), event.getOldUserKey(), null)});
        }
        return recordRequest;
    }

    private I18nHelper getI18n() {
        return this.i18nBeanFactory.getInstance(Locale.ENGLISH);
    }
}

