/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public final class AvatarImpl
implements Avatar {
    private static final String IMAGE_PNG = "image/png";
    private final Long id;
    private final String fileName;
    private final String owner;
    private final boolean systemAvatar;
    private static String TAGGED_AVATAR_FILE_SUFFIX = "jrvtg.png";
    private String contentType;
    private IconType iconType;

    AvatarImpl(Long id, String fileName, String contentType, IconType iconType, String owner, boolean systemAvatar) {
        this.id = id;
        this.fileName = (String)Assertions.notNull((String)"fileName", (Object)fileName);
        this.contentType = (String)Assertions.notNull((String)"contentType", (Object)contentType);
        this.iconType = (IconType)Assertions.notNull((String)"avatarType", (Object)iconType);
        this.systemAvatar = systemAvatar;
        if (!this.isSystemAvatar() && !AvatarImpl.isOldSystemAvatar(this.iconType, this.fileName)) {
            Assertions.notNull((String)"owner", (Object)owner);
            this.owner = owner;
        } else {
            if (owner != null) {
                throw new IllegalArgumentException("owner must be null for system avatars");
            }
            this.owner = null;
        }
    }

    public static AvatarImpl createCustomAvatar(String fileName, String contentType, String ownerId, IconType iconType) {
        return new AvatarImpl(null, AvatarImpl.toTaggedFilename(fileName), contentType, iconType, ownerId, false);
    }

    private static String toTaggedFilename(String fileName) {
        return FilenameUtils.removeExtension((String)fileName) + TAGGED_AVATAR_FILE_SUFFIX;
    }

    public static AvatarImpl createSystemAvatar(String fileName, String contentType, IconType iconType) {
        return new AvatarImpl(null, fileName, IMAGE_PNG, iconType, null, true);
    }

    @Nonnull
    public Avatar.Type getAvatarType() {
        if (Avatar.Type.supportsName((String)this.iconType.getKey())) {
            return Avatar.Type.getByName((String)this.iconType.getKey());
        }
        return Avatar.Type.OTHER;
    }

    @Nonnull
    public IconType getIconType() {
        return this.iconType;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Nonnull
    public String getContentType() {
        return this.contentType;
    }

    public Long getId() {
        return this.id;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isSystemAvatar() {
        return this.systemAvatar;
    }

    private static boolean isOldSystemAvatar(IconType iconType, String filename) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            return false;
        }
        if (iconType.equals((Object)IconType.PROJECT_ICON_TYPE)) {
            return demotedSystemProjectAvatars.contains(filename.toLowerCase());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvatarImpl avatar = (AvatarImpl)o;
        if (this.systemAvatar != avatar.systemAvatar) {
            return false;
        }
        if (!this.iconType.getKey().equals(avatar.getIconType().getKey())) {
            return false;
        }
        if (this.fileName != null ? !this.fileName.equals(avatar.fileName) : avatar.fileName != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(avatar.id) : avatar.id != null) {
            return false;
        }
        return !(this.owner != null ? !this.owner.equals(avatar.owner) : avatar.owner != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + (this.iconType != null ? this.iconType.getKey().hashCode() : 0);
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + (this.systemAvatar ? 1 : 0);
        return result;
    }
}

