/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.jira.upgrade.UpgradeConstraints;
import com.atlassian.jira.util.BuildUtilsInfo;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;

public class ConstrainedBuildUtilsInfo
implements BuildUtilsInfo {
    private final UpgradeConstraints constraints;
    private final BuildUtilsInfo buildUtilsInfo;

    public ConstrainedBuildUtilsInfo(UpgradeConstraints constraints, BuildUtilsInfo buildUtilsInfo) {
        this.constraints = Objects.requireNonNull(constraints);
        this.buildUtilsInfo = Objects.requireNonNull(buildUtilsInfo);
    }

    public int getApplicationBuildNumber() {
        return this.constraints.getTargetDatabaseBuildNumber();
    }

    public String getCurrentBuildNumber() {
        return Integer.toString(this.constraints.getTargetDatabaseBuildNumber());
    }

    public int getDatabaseBuildNumber() {
        return this.buildUtilsInfo.getDatabaseBuildNumber();
    }

    public String getMinimumUpgradableBuildNumber() {
        return this.buildUtilsInfo.getMinimumUpgradableBuildNumber();
    }

    public Date getCurrentBuildDate() {
        return this.buildUtilsInfo.getCurrentBuildDate();
    }

    public String getBuildPartnerName() {
        return this.buildUtilsInfo.getBuildPartnerName();
    }

    public String getBuildInformation() {
        return this.buildUtilsInfo.getBuildInformation();
    }

    @Deprecated
    public String getSvnRevision() {
        return this.buildUtilsInfo.getSvnRevision();
    }

    public String getCommitId() {
        return this.buildUtilsInfo.getCommitId();
    }

    public String getMinimumUpgradableVersion() {
        return this.buildUtilsInfo.getMinimumUpgradableVersion();
    }

    public Collection<Locale> getUnavailableLocales() {
        return this.buildUtilsInfo.getUnavailableLocales();
    }

    public String getSalVersion() {
        return this.buildUtilsInfo.getSalVersion();
    }

    public String getApplinksVersion() {
        return this.buildUtilsInfo.getApplinksVersion();
    }

    public String getCrowdOsgiVersion() {
        return this.buildUtilsInfo.getCrowdOsgiVersion();
    }

    public String getGuavaOsgiVersion() {
        return this.buildUtilsInfo.getGuavaOsgiVersion();
    }

    public String getBuildProperty(String key) {
        return this.buildUtilsInfo.getBuildProperty(key);
    }

    public boolean isBeta() {
        return this.buildUtilsInfo.isBeta();
    }

    public boolean isEap() {
        return this.buildUtilsInfo.isEap();
    }

    public boolean isFinal() {
        return this.buildUtilsInfo.isFinal();
    }

    public boolean isRc() {
        return this.buildUtilsInfo.isRc();
    }

    public boolean isSnapshot() {
        return this.buildUtilsInfo.isSnapshot();
    }

    public boolean isMilestone() {
        return this.buildUtilsInfo.isMilestone();
    }

    public String getVersion() {
        return this.buildUtilsInfo.getVersion();
    }

    public String getDocVersion() {
        return this.buildUtilsInfo.getDocVersion();
    }

    public int[] getVersionNumbers() {
        return this.buildUtilsInfo.getVersionNumbers();
    }
}

