/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.attachment;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.AttachmentValidator;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import io.atlassian.fugue.Either;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class DefaultAttachmentService
implements AttachmentService {
    private static final String ERROR_ATTACHMENT_DELETE_NON_EDITABLE_ISSUE = "attachment.service.error.delete.issue.non.editable";
    private static final String ERROR_ATTACHMENT_MANAGE_NO_PERMISSION = "attachment.service.error.manage.no.permission";
    private static final String ERROR_ATTACHMENT_DELETE_NO_PERMISSION = "attachment.service.error.delete.no.permission";
    private static final String ERROR_ATTACHMENTS_DISABLED = "attachment.service.error.attachments.disabled";
    private static final String ERROR_SCREENSHOT_APPLET_DISABLED = "attachment.service.error.screenshot.applet.disabled";
    private static final String ERROR_SCREENSHOT_APPLET_UNSUPPORTED_OS = "attachment.service.error.screenshot.applet.unsupported.os";
    private final AttachmentManager attachmentManager;
    private final AttachmentValidator attachmentValidator;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueUpdater issueUpdater;
    private final IssueManager issueManager;

    public DefaultAttachmentService(AttachmentManager attachmentManager, AttachmentValidator attachmentValidator, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, IssueUpdater issueUpdater, IssueManager issueManager) {
        this.attachmentManager = attachmentManager;
        this.attachmentValidator = attachmentValidator;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.issueUpdater = issueUpdater;
        this.issueManager = issueManager;
    }

    public boolean canDeleteAttachment(JiraServiceContext jiraServiceContext, Long attachmentId) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        Attachment attachment = this.getAndVerifyAttachment(attachmentId, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        Issue issue = this.getAndVerifyIssue(attachment, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        if (!this.isIssueInEditableWorkflowState(issue)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(ERROR_ATTACHMENT_DELETE_NON_EDITABLE_ISSUE));
            return false;
        }
        if (this.userHasAttachmentDeleteAllPermission(issue, user)) {
            return true;
        }
        if (this.userHasAttachmentDeleteOwnPermission(issue, user) && this.isUserAttachmentAuthor(attachment, user)) {
            return true;
        }
        jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(ERROR_ATTACHMENT_DELETE_NO_PERMISSION, attachmentId.toString()));
        return false;
    }

    public boolean canManageAttachments(JiraServiceContext jiraServiceContext, Issue issue) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        boolean hasDeletePerm = this.canDeleteAnyAttachment(user, issue, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        if (!this.isAttachmentsEnabledAndPathSet()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(ERROR_ATTACHMENTS_DISABLED));
            return false;
        }
        boolean hasCreatePerm = this.userHasCreateAttachmentPermission(issue, user);
        if (hasCreatePerm || hasDeletePerm) {
            return true;
        }
        jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(ERROR_ATTACHMENT_MANAGE_NO_PERMISSION));
        return false;
    }

    public void delete(JiraServiceContext jiraServiceContext, Long attachmentId) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        ApplicationUser user = jiraServiceContext.getLoggedInUser();
        Attachment attachment = this.getAndVerifyAttachment(attachmentId, errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        Issue issue = this.getAndVerifyIssue(attachment, errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        try {
            this.attachmentManager.deleteAttachment(attachment);
        }
        catch (RemoveException e) {
            errorCollection.addErrorMessage(this.getText("attachment.service.error.delete.attachment.failed", attachmentId.toString()));
            return;
        }
        IssueUpdateBean issueUpdateBean = this.constructIssueUpdateBeanForAttachmentDelete(attachment, issue, user);
        this.issueUpdater.doUpdate(issueUpdateBean, true);
    }

    public Attachment getAttachment(JiraServiceContext jiraServiceContext, Long attachmentId) throws AttachmentNotFoundException {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        return this.getAndVerifyAttachment(attachmentId, errorCollection);
    }

    public boolean canCreateAttachments(JiraServiceContext jiraServiceContext, @Nullable Project project) {
        return this.validateNonNullProject(jiraServiceContext, project) && this.attachmentValidator.canCreateTemporaryAttachments(jiraServiceContext.getLoggedInApplicationUser(), Either.right((Object)project), jiraServiceContext.getErrorCollection());
    }

    public boolean canCreateTemporaryAttachments(JiraServiceContext jiraServiceContext, @Nullable Issue issue) {
        return this.validateNonNullIssue(jiraServiceContext, issue) && this.attachmentValidator.canCreateTemporaryAttachments(jiraServiceContext.getLoggedInApplicationUser(), Either.left((Object)issue), jiraServiceContext.getErrorCollection());
    }

    public boolean canCreateAttachments(JiraServiceContext jiraServiceContext, Issue issue) {
        return this.validateNonNullIssue(jiraServiceContext, issue) && this.attachmentValidator.canCreateAttachments(jiraServiceContext.getLoggedInApplicationUser(), issue, jiraServiceContext.getErrorCollection());
    }

    private boolean validateNonNullProject(JiraServiceContext jiraServiceContext, @Nullable Project project) {
        if (project == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getText("attachment.service.error.null.project"));
            return false;
        }
        return true;
    }

    private boolean validateNonNullIssue(JiraServiceContext jiraServiceContext, @Nullable Issue issue) {
        if (issue == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getText("attachment.service.error.null.issue"));
            return false;
        }
        return true;
    }

    public boolean canAttachScreenshots(JiraServiceContext jiraServiceContext, Issue issue) {
        if (!this.canCreateAttachments(jiraServiceContext, issue)) {
            return false;
        }
        return this.isScreenshotAppletEnabledAndSupportedByOS(jiraServiceContext);
    }

    boolean isIssueInEditableWorkflowState(Issue issue) {
        return this.issueManager.isEditable(issue);
    }

    boolean isScreenshotAppletEnabledAndSupportedByOS(JiraServiceContext jiraServiceContext) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (!this.attachmentManager.isScreenshotAppletEnabled()) {
            errorCollection.addErrorMessage(this.getText(ERROR_SCREENSHOT_APPLET_DISABLED));
            return false;
        }
        if (!this.attachmentManager.isScreenshotAppletSupportedByOS()) {
            errorCollection.addErrorMessage(this.getText(ERROR_SCREENSHOT_APPLET_UNSUPPORTED_OS));
            return false;
        }
        return true;
    }

    boolean isAttachmentsEnabledAndPathSet() {
        return this.attachmentManager.attachmentsEnabled();
    }

    Issue getAndVerifyIssue(Attachment attachment, ErrorCollection errorCollection) {
        Issue issue = attachment.getIssueObject();
        if (issue == null) {
            errorCollection.addErrorMessage(this.getText("attachment.service.error.null.issue.for.attachment", attachment.getId().toString()));
            return null;
        }
        return issue;
    }

    Attachment getAndVerifyAttachment(Long attachmentId, ErrorCollection errorCollection) {
        if (attachmentId == null) {
            errorCollection.addErrorMessage(this.getText("attachment.service.error.null.attachment.id"));
            return null;
        }
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
        if (attachment == null) {
            errorCollection.addErrorMessage(this.getText("attachment.service.error.null.attachment", attachmentId.toString()));
        }
        return attachment;
    }

    IssueUpdateBean constructIssueUpdateBeanForAttachmentDelete(Attachment attachment, Issue issue, ApplicationUser user) {
        ChangeItemBean changeItem = new ChangeItemBean("jira", "Attachment", attachment.getId().toString(), attachment.getFilename(), null, null);
        List changeItemBeans = EasyList.build((Object)changeItem);
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issue.getGenericValue(), issue.getGenericValue(), EventType.ISSUE_UPDATED_ID, user);
        issueUpdateBean.setChangeItems((Collection)changeItemBeans);
        issueUpdateBean.setDispatchEvent(true);
        issueUpdateBean.setParams(MapBuilder.build((Object)"eventsource", (Object)"action"));
        return issueUpdateBean;
    }

    boolean userHasAttachmentDeleteAllPermission(Issue issue, ApplicationUser user) {
        return this.permissionManager.hasPermission(38, issue, user);
    }

    boolean userHasAttachmentDeleteOwnPermission(Issue issue, ApplicationUser user) {
        return this.permissionManager.hasPermission(39, issue, user);
    }

    boolean userHasCreateAttachmentPermission(Issue issue, ApplicationUser user) {
        return this.permissionManager.hasPermission(19, issue, user);
    }

    boolean isUserAttachmentAuthor(Attachment attachment, ApplicationUser user) {
        ApplicationUser attachmentAuthor = attachment.getAuthorObject();
        if (attachmentAuthor == null && Users.isAnonymous((ApplicationUser)user)) {
            return true;
        }
        if (attachmentAuthor == null || Users.isAnonymous((ApplicationUser)user)) {
            return false;
        }
        return attachmentAuthor.equals((Object)user);
    }

    boolean isAuthorOfAtLeastOneAttachment(Issue issue, ApplicationUser user) {
        List attachments = this.attachmentManager.getAttachments(issue);
        for (Attachment attachment : attachments) {
            if (!this.isUserAttachmentAuthor(attachment, user)) continue;
            return true;
        }
        return false;
    }

    boolean canDeleteAnyAttachment(ApplicationUser user, Issue issue, ErrorCollection errorCollection) {
        if (issue == null) {
            errorCollection.addErrorMessage(this.getText("attachment.service.error.null.issue"));
            return false;
        }
        if (this.userHasAttachmentDeleteAllPermission(issue, user)) {
            return true;
        }
        if (this.userHasAttachmentDeleteOwnPermission(issue, user)) {
            return this.isAuthorOfAtLeastOneAttachment(issue, user);
        }
        return false;
    }

    private String getText(String key) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key);
    }

    private String getText(String key, String param) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param);
    }
}

