/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.comment.property;

import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyHelper;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.event.issue.comment.property.CommentPropertyDeletedEvent;
import com.atlassian.jira.event.issue.comment.property.CommentPropertySetEvent;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.comments.CommentSearchManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import io.atlassian.fugue.Option;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CommentPropertyHelper
implements EntityPropertyHelper<Comment> {
    private final CommentPermissionManager commentPermissionManager;
    private final CommentSearchManager commentSearchManager;
    private final I18nHelper i18n;
    private final EntityPropertyHelper.CheckPermissionFunction<Comment> hasEditPermissionFunction = new EntityPropertyHelper.CheckPermissionFunction<Comment>(){

        public ErrorCollection apply(ApplicationUser applicationUser, Comment comment) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            if (!CommentPropertyHelper.this.commentPermissionManager.hasEditPermission(applicationUser, comment)) {
                ErrorCollection.Reason reason = applicationUser == null ? ErrorCollection.Reason.NOT_LOGGED_IN : ErrorCollection.Reason.FORBIDDEN;
                errorCollection.addErrorMessage(CommentPropertyHelper.this.i18n.getText("comment.service.error.no.edit.permission.no.user"), reason);
            }
            return errorCollection;
        }
    };
    private final EntityPropertyHelper.CheckPermissionFunction<Comment> hasReadPermissionFunction = new EntityPropertyHelper.CheckPermissionFunction<Comment>(){

        public ErrorCollection apply(ApplicationUser applicationUser, Comment comment) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            if (!CommentPropertyHelper.this.commentPermissionManager.hasBrowsePermission(applicationUser, comment)) {
                ErrorCollection.Reason reason = applicationUser == null ? ErrorCollection.Reason.NOT_LOGGED_IN : ErrorCollection.Reason.FORBIDDEN;
                errorCollection.addErrorMessage(CommentPropertyHelper.this.i18n.getText("comment.service.error.no.comment.visibility.no.user"), reason);
            }
            return errorCollection;
        }
    };
    private final Function<Long, Option<Comment>> entityByIdFunction = new Function<Long, Option<Comment>>(){

        @Override
        public Option<Comment> apply(Long id) {
            return Option.option((Object)CommentPropertyHelper.this.commentSearchManager.getCommentById(id));
        }
    };
    private final BiFunction<ApplicationUser, EntityProperty, CommentPropertySetEvent> setPropertyEventFunction = new BiFunction<ApplicationUser, EntityProperty, CommentPropertySetEvent>(){

        @Override
        public CommentPropertySetEvent apply(ApplicationUser user, EntityProperty entityProperty) {
            return new CommentPropertySetEvent(entityProperty, user);
        }
    };
    private final BiFunction<ApplicationUser, EntityProperty, CommentPropertyDeletedEvent> deletePropertyEventFunction = new BiFunction<ApplicationUser, EntityProperty, CommentPropertyDeletedEvent>(){

        @Override
        public CommentPropertyDeletedEvent apply(ApplicationUser user, EntityProperty entityProperty) {
            return new CommentPropertyDeletedEvent(entityProperty, user);
        }
    };

    public CommentPropertyHelper(CommentPermissionManager commentPermissionManager, CommentSearchManager commentSearchManager, I18nHelper i18n) {
        this.commentPermissionManager = commentPermissionManager;
        this.commentSearchManager = commentSearchManager;
        this.i18n = i18n;
    }

    public EntityPropertyHelper.CheckPermissionFunction<Comment> hasEditPermissionFunction() {
        return this.hasEditPermissionFunction;
    }

    public EntityPropertyHelper.CheckPermissionFunction<Comment> hasReadPermissionFunction() {
        return this.hasReadPermissionFunction;
    }

    public Function<Long, Option<Comment>> getEntityByIdFunction() {
        return this.entityByIdFunction;
    }

    public BiFunction<ApplicationUser, EntityProperty, CommentPropertySetEvent> createSetPropertyEventBiFunction() {
        return this.setPropertyEventFunction;
    }

    public BiFunction<ApplicationUser, EntityProperty, CommentPropertyDeletedEvent> createDeletePropertyEventBiFunction() {
        return this.deletePropertyEventFunction;
    }

    public EntityPropertyType getEntityPropertyType() {
        return EntityPropertyType.COMMENT_PROPERTY;
    }
}

