/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.search;

import com.atlassian.jira.bc.issue.search.AbstractIssuePickerSearchProvider;
import com.atlassian.jira.bc.issue.search.IssuePickerSearchService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.util.LuceneQueryModifier;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SortOrder;

public class HistoryIssuePickerSearchProvider
extends AbstractIssuePickerSearchProvider {
    public HistoryIssuePickerSearchProvider(IssueFactory issueFactory, SearchProvider searchProvider, ConstantsManager constantsManager, LuceneQueryModifier modifier) {
        super(issueFactory, searchProvider, constantsManager, modifier);
    }

    @Override
    protected String getId() {
        return "hs";
    }

    @Override
    protected String getLabelKey() {
        return "jira.ajax.autocomplete.history.search";
    }

    @Override
    protected SearchRequest getRequest(IssuePickerSearchService.IssuePickerParameters issuePickerParams) {
        Clause clause = JqlQueryBuilder.newClauseBuilder().issueInHistory().buildClause();
        OrderBy orderBy = JqlQueryBuilder.newOrderByBuilder().lastViewedDate(SortOrder.DESC, true).buildOrderBy();
        QueryImpl query = new QueryImpl(clause, orderBy, null);
        return new SearchRequest((Query)query);
    }

    @Override
    public boolean handlesParameters(ApplicationUser searcher, IssuePickerSearchService.IssuePickerParameters issuePickerParams) {
        return true;
    }
}

